/***************************************************************
   PERSONAL ENERGETIC PROFILE (PEP) ENGINE v25.1.0
   Turtle Calendar + THD Framework
   4,122 Unique Harmonic Identities
   
   COMPLETE ENGINE - NO TRUNCATION
   Ready for WordPress deployment
****************************************************************/

/***************************************************************
   SHA-256 INLINE IMPLEMENTATION
****************************************************************/
function sha256(ascii) {
  function rightRotate(v, a){return (v>>>a)|(v<<(32-a));}

  var mathPow = Math.pow, maxWord = mathPow(2, 32);
  var result = '';

  var words = [], asciiBitLength = ascii.length * 8;

  var hash = sha256.h = sha256.h || [];
  var k = sha256.k = sha256.k || [];
  var primeCounter = k.length;

  var isComposite = {};
  for (var candidate = 2; primeCounter < 64; candidate++) {
    if (!isComposite[candidate]) {
      for (var i = 0; i < 313; i += candidate) isComposite[i] = candidate;
      hash[primeCounter] = (mathPow(candidate, .5) * maxWord) | 0;
      k[primeCounter++] = (mathPow(candidate, 1/3) * maxWord) | 0;
    }
  }

  ascii += '\x80';
  while (ascii.length % 64 - 56) ascii += '\x00';

  for (let i = 0; i < ascii.length; i++) {
    let j = ascii.charCodeAt(i);
    words[i >> 2] |= j << ((3 - i) % 4) * 8;
  }

  words[words.length] = (asciiBitLength / maxWord) | 0;
  words[words.length] = asciiBitLength;

  for (let j = 0; j < words.length;) {
    let w = words.slice(j, j += 16);
    let oldHash = hash;
    hash = hash.slice();

    for (let i = 0; i < 64; i++) {
      let w15 = w[i - 15], w2 = w[i - 2];

      let a = hash[0], e = hash[4];
      let temp1 = hash[7]
        + (rightRotate(e,6)^rightRotate(e,11)^rightRotate(e,25))
        + ((e&hash[5])^((~e)&hash[6]))
        + k[i]
        + (w[i] = (i < 16) ? w[i] :
            (w[i-16]
            + (rightRotate(w15,7)^rightRotate(w15,18)^(w15>>>3))
            + w[i-7]
            + (rightRotate(w2,17)^rightRotate(w2,19)^(w2>>>10)))|0);

      let temp2 = (rightRotate(a,2)^rightRotate(a,13)^rightRotate(a,22))
        + ((a&hash[1])^(a&hash[2])^(hash[1]&hash[2]));

      hash = [(temp1+temp2)|0].concat(hash);
      hash[4] = (hash[4] + temp1) | 0;
    }

    for (let i = 0; i < 8; i++) hash[i] = (hash[i] + oldHash[i]) | 0;
  }

  for (let i = 0; i < 8; i++)
    for (let j = 3; j + 1; j--)
      result += ((hash[i] >> (j * 8)) & 255).toString(16).padStart(2, '0');

  return result;
}

function getBase58(num) {
  const chars = '123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz';
  const base = chars.length;
  let out = '';
  
  while (num >= base) {
    const rem = num % base;
    out = chars[rem] + out;
    num = Math.floor(num / base);
  }
  
  if (num > 0) out = chars[num] + out;
  return out || '1';
}

function clean(text) {
  if (!text) return '';
  return text.toLowerCase()
    .normalize('NFC')
    .replace(/[^a-z0-9\s]/g, '')
    .replace(/\s+/g, ' ')
    .trim();
}

const PHONEME_MAP = {
  'D': 'Determination', 'K': 'Crystallization', 'L': 'Luminescence',
  'M': 'Materialization', 'N': 'Nexus', 'R': 'Resonance',
  'S': 'Source Energy', 'SH': 'Shamanic Depth', 'T': 'Structure',
  'TH': 'Threshold', 'V': 'Vitality', 'Z': 'Zenith',
  'B': 'Building', 'F': 'Frequency', 'G': 'Grounding', 'H': 'Harmonics',
  'J': 'Joy', 'P': 'Projection', 'W': 'Wave', 'Y': 'Yielding',
  'a': 'Adaptability', 'ay': 'Expression', 'e': 'Energy', 'ee': 'High Frequency',
  'i': 'Intuition', 'o': 'Wholeness', 'oh': 'Opening', 'u': 'Understanding'
};

const THD_PHASES = {
  3: {
    name: 'Triune Phase',
    rhythm: 'Creation Cycle',
    description: 'You move through life in rapid 3-beat cycles: initiate → stabilize → release. Your natural tempo is quick iteration and fast integration.',
    strength: 'Rapid adaptation and swift pattern recognition',
    challenge: 'Can miss depth by moving too quickly through cycles',
    timing: 'Best decisions made in 3-day, 3-week, or 3-month windows'
  },
  6: {
    name: 'Harmonic Phase',
    rhythm: 'Balance Cycle',
    description: 'You move through life in balanced 6-beat cycles: build → peak → dissolve → rebuild. Your natural tempo is measured development with clear phases.',
    strength: 'Sustained effort and recognition of natural peaks/valleys',
    challenge: 'Can get stuck in middle phases, avoiding necessary completion',
    timing: 'Best decisions made in 6-week or 6-month cycles'
  },
  9: {
    name: 'Completion Phase',
    rhythm: 'Mastery Cycle',
    description: 'You move through life in deep 9-beat cycles: inception → development → mastery → completion. Your natural tempo is slow, thorough transformation.',
    strength: 'Deep mastery and complete integration of experience',
    challenge: 'Can resist starting new cycles, holding onto completion too long',
    timing: 'Best decisions made in 9-month or 9-year cycles'
  }
};

const SCALAR_MODULATORS = {
  'Action': {
    posture: 'Yang / Outward / Kinetic',
    description: 'Your default energetic posture is ACTION. You process reality by doing, moving, engaging. Stillness feels like stagnation.',
    expression: 'You think by moving, learn by doing, and resolve friction through physical engagement.',
    shadow: 'Over-action without integration can lead to burnout and scattered energy.',
    alignment: 'Honor your need for movement. Build in recovery between action cycles.'
  },
  'Reflection': {
    posture: 'Neutral / Inward / Observational',
    description: 'Your default energetic posture is REFLECTION. You process reality by observing, analyzing, synthesizing. Rushing feels chaotic.',
    expression: 'You think by contemplating, learn by integration, and resolve friction through understanding.',
    shadow: 'Over-reflection without action can lead to analysis paralysis and disconnection.',
    alignment: 'Honor your need for processing time. Trust insights before acting.'
  },
  'Restoration': {
    posture: 'Yin / Receptive / Regenerative',
    description: 'Your default energetic posture is RESTORATION. You process reality by resting, receiving, regenerating. Constant output depletes you.',
    expression: 'You think by allowing, learn by absorption, and resolve friction through rest and renewal.',
    shadow: 'Over-restoration without engagement can lead to withdrawal and energetic collapse.',
    alignment: 'Honor your need for regeneration. Quality output requires deep rest cycles.'
  }
};

const ARCHETYPES = {
  'Visionary': {
    contract: 'To seed future timelines and perceive the architecture of tomorrow before it manifests in the physical realm. You are not here to maintain what exists—you are here to sense what MUST exist and call it into being. Your consciousness naturally extends forward in time, reading probability fields and detecting emergent patterns that others cannot yet perceive. This is not imagination or wishful thinking; it is a genuine perceptual capacity that allows you to see the scaffolding of futures that are trying to crystallize into reality. Your sacred duty is to anchor these visions, communicate them to those who can help manifest them, and trust the timeline even when the present seems to contradict what you see coming.',
    glitch_name: 'Temporal Disconnect',
    glitch_desc: 'Your primary dysfunction occurs when you live entirely in the future while neglecting the physical vessel and present-moment reality. This manifests as chronic anxiety (which is actually ungrounded future-energy with nowhere to discharge), difficulty with practical tasks and daily maintenance, a sense of being "trapped" in the present, impatience with people who cannot see what you see, and a tendency to abandon projects once you have "seen" the outcome (because for you, the vision IS the completion). You may find yourself unable to enjoy current successes because you are already focused on the next horizon. Relationships suffer because partners feel you are never fully "here." Your body may develop symptoms from being ignored—you forget to eat, sleep irregularly, and treat your physical form as an inconvenient limitation rather than the vehicle through which vision becomes reality.',
    glitch_fix: 'Ground the vision through physical action. This is not optional—it is the mechanism by which your gift becomes functional rather than torturous. Specific practices: Touch the earth daily with bare hands or feet for at least 5 minutes. Engage in manual labor that produces tangible results (gardening, building, cooking). When anxiety spikes, immediately do something physical—push-ups, walking, cleaning. Create a "vision grounding" practice where you write or speak your visions, then immediately take ONE physical action toward them. Work with your hands. The future you see is not meant to replace the present; it is meant to be BUILT through the present. Every moment you spend grounded is a moment your vision gets clearer, not dimmer.',
    oil_name: 'Frankincense',
    oil_desc: 'The supreme oil for Visionary alignment. Frankincense has been used for millennia in sacred ceremonies precisely because it opens the crown chakra and enhances connection to higher dimensional perception. For you, it serves a dual purpose: it amplifies your natural future-sight capacity while simultaneously grounding that perception into your body through the olfactory-limbic connection. Apply to the crown of your head and the soles of your feet simultaneously to create a "grounded channel" for vision. Use during any visioning practice, before important strategic sessions, or when you feel unmoored from your timeline. The resin form burned as incense creates a sacred container for your most important downloads.',
    crystal_name: 'Clear Quartz',
    crystal_desc: 'The master amplifier and programmer of intention. Clear Quartz resonates with your Visionary function because it does exactly what you do: it receives, amplifies, stores, and transmits information across time. This crystal literally contains the capacity to hold and broadcast programmed intentions into probability fields—it is a physical anchor for your timeline work. Use it to "record" your most important visions by holding it during visioning sessions. Place programmed quartz in locations where you need the vision to manifest. Wear it to maintain signal clarity throughout your day. Clear Quartz also helps with the Visionary challenge of mental overwhelm—it organizes chaotic perception into coherent patterns. Keep one on your desk, one by your bed, and one that you carry with you.',
    metal_name: 'Gold',
    metal_desc: 'Gold is the supreme conductor of high-frequency information and solar consciousness. It does not corrode, does not degrade, and maintains its coherence across time—exactly the qualities your visions need to manifest. Gold resonates with the solar plexus (will) and crown (vision), creating the circuit necessary to bring future sight into present action. Wearing gold, particularly near the head or heart, helps stabilize your visionary downloads and gives them the "weight" needed to land in physical reality. Gold also serves as a protection against energy drain—Visionaries are often targeted by those who want to harvest their sight without supporting their grounding. Gold creates a sovereign field around your perception.',
    animal_name: 'Hawk',
    animal_desc: 'The Hawk is your spirit teacher because it embodies grounded vision—the exact integration you are learning to master. Hawks see with extraordinary precision from great heights, but they do not live in the sky; they hunt, they nest, they engage with the physical world. Their vision serves survival and action, not abstraction. When Hawk appears in your life (physically, in dreams, or as a symbol), it is reminding you to scan the horizon AND engage with what you find. Hawks teach patience—they circle, they wait, they watch—and then they act with decisive precision. They do not doubt what they see; they trust their perception and move. Learn from Hawk: your vision is trustworthy. The question is not "is this real?" but "how do I bring this down to earth?"',
    music_name: 'Ambient / Ethereal',
    music_desc: 'Spacious soundscapes that mirror the infinite possibility field of your natural perception. Ambient music works for Visionaries because it creates SPACE without demanding LINEAR attention. Your mind naturally operates in holographic, non-linear patterns; music with strong beats and predictable structures can actually constrain your visionary capacity. Ambient music—think Brian Eno, Stars of the Lid, Hammock—opens the perceptual field and allows future-data to flow in. Use it during visioning sessions, strategic planning, or any time you need to access your timeline sight. However, balance this with grounding music (drums, bass-heavy tracks) when you need to land your visions into action. The ethereal opens the channel; the grounded brings it down.',
    color_name: 'Violet',
    color_desc: 'Violet sits at the highest visible frequency of the light spectrum—it is literally the color closest to the invisible, the threshold between what can be seen and what can only be sensed. This is your operational territory. Violet activates the crown chakra and third eye simultaneously, enhancing both reception (crown) and interpretation (third eye) of future data. Surround yourself with violet in your visioning space. Wear it when you need enhanced perception. Visualize violet light flooding your crown during meditation. However, balance violet with earth tones (brown, green, terracotta) in your daily environment to maintain grounding. Too much violet without earth anchoring amplifies the Temporal Disconnect glitch.',
    freq_name: '963 Hz',
    freq_desc: 'The frequency of pure Oneness and connection to Source consciousness. 963 Hz dissolves the perceptual boundaries that normally separate "now" from "future," allowing your natural timeline sight to operate without interference. This is the frequency of the Sahasrara (crown chakra) and is sometimes called the "frequency of the Gods." For Visionaries, 963 Hz serves as a tuning fork that aligns your perception with the highest probability timelines—not just any future, but the future most aligned with collective evolution. Use this frequency during meditation, visioning sessions, or when you feel disconnected from your purpose. Combine with 396 Hz (grounding) to maintain the heaven-earth bridge that makes your visions actionable.',
    geo_name: 'Star Tetrahedron',
    geo_desc: 'The Star Tetrahedron (Merkaba) is the geometry of the lightbody—two interlocking tetrahedra representing the integration of heaven and earth, spirit and matter, future and present. This is THE geometric form for Visionaries because it literally encodes the function you are designed to perform: bringing higher dimensional information down into three-dimensional reality. Meditate on this form. Visualize it surrounding your body with one tetrahedron pointing up (receiving vision) and one pointing down (grounding vision). The counter-rotation of these forms in Merkaba meditation activates your natural capacity while maintaining stability. Keep a physical Star Tetrahedron in your workspace as a reminder and anchor for your function.',
    gid_in: 'Holographic Intake',
    gid_in_d: 'You do not absorb information linearly—you receive entire conceptual structures instantaneously, like downloading a complete hologram rather than reading a book word by word. This means you often "get" things before you can explain how you know them. You see the whole pattern before you see the parts. In conversations, you may become impatient with sequential explanations because you have already grasped the conclusion. In learning, you need the big picture FIRST, then details make sense. Your intake is also cross-temporal: you receive data from probable futures as readily as from the present moment. This is not imagination; it is a genuine perceptual capacity. The challenge is that holographic intake can be overwhelming—you may receive more than you can process, leading to anxiety or shutdown.',
    gid_proc: 'Future-Casting',
    gid_proc_d: 'Your primary cognitive processing method is simulation of future outcomes. When faced with any decision, situation, or idea, your mind automatically projects it forward in time and "watches" how it unfolds across multiple probability branches. This is why you often know which projects will succeed or fail before others see any evidence—you have already run the simulation. This processing style makes you invaluable for strategy, planning, and risk assessment. The shadow side: you may become attached to specific futures and resist when reality takes a different branch. You may also "live" in your simulations rather than engaging with present reality. Mastery comes when you can future-cast AND remain present, using your simulations as guidance rather than replacement for lived experience.',
    gid_dec: 'Resonant Flash',
    gid_dec_d: 'Your decision-making is not logical or emotional—it is claircognizant. Decisions arrive as instant knowing, a "flash" of certainty that does not require (and often cannot provide) rational justification. You simply KNOW. This is direct perception of timeline alignment: when a decision resonates, it is because it aligns with the highest probability future you are meant to anchor. When it does not resonate, no amount of logical argument will make it feel right. Trust this capacity. Your resonant flash is more accurate than analysis for YOUR path (though others may need to reach conclusions differently). The challenge: explaining your decisions to those who need logical frameworks. Learn to reverse-engineer explanations for decisions you have already made through resonance.',
    gid_out: 'Symbolic Transmission',
    gid_out_d: 'You communicate most powerfully through symbols, metaphors, and imagery rather than linear explanation. This is because your perceptions ARE holographic and symbolic—translating them into sequential language necessarily loses information. When you speak in metaphor, you are actually being MORE precise, not less. Your symbols carry compressed data that unpacks in the receiver over time. Lean into this capacity. Use visual aids, stories, and analogies. Create symbols for your visions that others can hold and work with. The challenge: those who process linearly may find your communication "vague" or "impractical." Learn to bridge—offer the symbol first (for those who can receive it), then translate into steps (for those who need sequence). Both are valid; both are needed.',
    rel_align: 'You thrive in relationships characterized by Parallel Play—partnerships where both individuals have their own strong vision and sovereign direction, and the relationship serves as a supportive base camp rather than the primary focus. You need partners who can match your frequency (or at least not drag it down), who are excited by ideas and possibilities, and who do not require you to be constantly "present" in the mundane sense. The ideal Visionary partner is themselves engaged with meaningful work, gives you space to vision and create, and is genuinely supportive of futures they may not fully see yet. Avoid partners who need you to be their anchor, who are threatened by your timeline sight, or who demand you "be realistic."',
    rel_chal: 'Your primary relationship challenge is valuing potential over reality—falling in love with who someone COULD be rather than who they are, staying in situations because you can "see" a better future even when present evidence contradicts it, and neglecting relationship maintenance because you are focused on the horizon. You may also struggle with presence—partners feel you are never fully "here," that you are always partially elsewhere. This creates loneliness in those who love you. The work: learn to see people clearly AS THEY ARE, not just as they could be. Practice presence as a discipline. Understand that relationships, like visions, require grounding to become real.',
    ritual_name: 'The Horizon Anchor',
    ritual_steps: [
      'Stand facing the sun, or toward a window with natural light, preferably at sunrise or sunset when the horizon is visible. This orients your body toward the threshold between visible and invisible—your natural territory.',
      'Close your eyes and allow your highest timeline to present itself. Do not force or direct; simply ask "Show me" and receive. Let the vision arrive as image, feeling, knowing, or symbol. This is your future self, your highest work, your deepest contribution.',
      'Visualize this timeline as a golden thread extending from your heart toward the horizon. Feel the connection. Feel the PULL. This timeline WANTS to manifest through you; you are its anchor point in present reality.',
      'Open your eyes, maintaining awareness of the golden thread. Now physically STOMP your feet three times—hard, deliberate, grounded. With each stomp, declare internally: "This future enters through ME. I am the door. I am here NOW."',
      'The stomping serves a specific function: it discharges the electrical energy of vision into the ground while simultaneously anchoring your body as the conduit. You are literally grounding a lightning rod.',
      'Complete by placing both hands on your heart and breathing three deep breaths. You have just performed the core Visionary function: receiving from above and grounding below. Carry this integrated state into your day.'
    ],
    vocation: 'Futurist / Strategist',
    cycle: 'Initiation',
    cycle_desc: 'The sparking of new timelines—you are designed to be present at beginnings, to see what wants to emerge, and to catalyze its first manifestation.',
    summary_synthesis: 'You are a bridge between the timeline that is and the timeline that must be. This is not a metaphor—it is a literal description of your function in the collective. Your nervous system is wired to receive future-data; your cognition naturally simulates probability fields; your knowing arrives as resonant flash rather than logical conclusion. The anxiety you have felt your whole life is not pathology—it is ungrounded electricity, vision-energy with nowhere to discharge. When you anchor your sight in physical action, when you stomp your feet and build with your hands and GROUND the lightning that flows through you, you cease to be a dreamer and become what you were always meant to be: an architect of destiny. The future needs anchors in the present. That is what you are. Stop apologizing for seeing what others cannot. Start building what you see.'
  },
  'Builder': {
    contract: 'To manifest structure from chaos and create systems that endure for generations. You are the architect of physical reality, the one who takes raw potential and gives it form, function, and permanence. While others dream and vision and disrupt, YOU are the one who actually builds the thing—the business, the organization, the home, the system, the framework that will outlast you. This is not a secondary role; it is THE essential function. Without Builders, visions remain visions, ideas remain ideas, and nothing actually changes in the material world. Your sacred duty is to assess what is structurally sound, to create foundations that can bear weight, and to have the patience and discipline to build properly rather than quickly. You are here to leave something behind that others can stand upon.',
    glitch_name: 'Rigidity Lock',
    glitch_desc: 'Your primary dysfunction occurs when structure becomes prison—when you become so attached to your blueprints that you refuse to adapt when reality shifts. This manifests as an inability to pivot even when evidence clearly shows the plan is not working, controlling behavior toward anyone who threatens your carefully constructed systems, emotional unavailability (because emotions are messy and do not fit the blueprint), and a tendency to force reality to fit your plan rather than adjusting the plan to fit reality. You may find yourself defending structures that have outlived their usefulness, fighting against necessary change, or becoming rigid in relationships because vulnerability does not compute. Your strength—the ability to create lasting form—becomes a trap when you cannot release form that no longer serves. The strongest structures in nature (trees, skeletons, coastlines) are those that can flex; pure rigidity leads to shattering.',
    glitch_fix: 'Introduce flexible chaos deliberately and regularly. This is counterintuitive for you—chaos feels like the enemy—but it is actually the medicine. Specific practices: Build "flex points" into all your plans, explicit places where adjustment is expected and welcomed. Once a week, do something completely unplanned—no agenda, no outcome, just see what happens. Practice saying "I don\'t know" and "Let\'s see" instead of always having the answer. In relationships, schedule unstructured time where the other person leads and you follow without trying to organize. Physically, move your body in unstructured ways—dance, play, improvise—rather than always exercising according to a program. When you feel the urge to control, ask: "What am I afraid of?" Usually, the rigidity is protecting against a fear of collapse. But you are strong enough to flex. Flexibility does not mean weakness; it means structures that last.',
    oil_name: 'Cedarwood',
    oil_desc: 'The quintessential Builder oil. Cedarwood provides the deep grounding you need to pull chaotic potential down into solid form. It has been used since ancient times in temple construction precisely because it carries the frequency of sacred structure—form that serves spirit. For you, Cedarwood serves multiple functions: it calms the nervous system when you feel overwhelmed by disorder, it enhances focus during construction phases, and it connects you to the archetypal Builder energy that flows through all who have created lasting form throughout history. Apply to the base of your spine and the soles of your feet to enhance grounding. Diffuse it in your workspace during focused building sessions. Use it when you need to make structural decisions. The scent of Cedarwood is the scent of "this will last."',
    crystal_name: 'Hematite',
    crystal_desc: 'Hematite is iron oxide—literally, metal that has been grounded into stone. This is the perfect metaphor for your function: you take high-energy raw material and give it dense, stable, enduring form. Hematite anchors scattered energy into the body and into physical reality. It provides structural integrity to your energetic field, creating a stable container from which you can build without being destabilized by chaos around you. For Builders, Hematite serves as a reminder and an anchor: hold it when you need to make foundation-level decisions, place it on your desk during construction phases, carry it when you must enter chaotic environments without losing your center. Hematite also helps with the Builder shadow—when you feel yourself becoming rigid, hold Hematite and ask it to help you find the balance between form and flow.',
    metal_name: 'Iron',
    metal_desc: 'Iron is THE metal of Builders—it is strong, magnetic, and fundamental to the structure of both Earth and blood. Iron provides the endurance required to build things that last. It represents the marriage of strength and utility; iron is not decorative, it is functional. It does the work. For you, iron resonance supports the long-haul stamina that building requires. Where others sprint and burn out, you need marathon capacity. Iron also provides magnetic grounding—it literally helps you stay anchored to the Earth while you work. Wear iron (or steel, which is iron-based) as jewelry, keep iron objects in your workspace, or simply spend time appreciating iron structures (bridges, beams, tools) as reminders of what patient, skilled building creates. Iron teaches: strength serves function. Form follows necessity. Build what is needed, not what is flashy.',
    animal_name: 'Beaver',
    animal_desc: 'The Beaver is your spirit teacher because it is the supreme Builder of the animal kingdom—the only animal besides humans that significantly reshapes its environment to meet its needs. Beavers build dams, lodges, and canal systems of remarkable sophistication. They work with available materials, they plan for seasons they cannot yet see, and they maintain their structures continually. This is your medicine. When Beaver appears in your life, it is asking: Are you building with what is available, or waiting for perfect materials? Are you maintaining what you have built, or only interested in new construction? Are you building for the long term, or just for immediate needs? Beavers also teach the value of creating environments that support life—their dams create wetlands that support entire ecosystems. What are you building that will support life beyond your own?',
    music_name: 'Classical / Orchestral',
    music_desc: 'Classical music resonates with Builder consciousness because it demonstrates what you intuitively understand: complex, layered structure can create perfect harmony. An orchestra is dozens of individual instruments, each playing distinct parts, unified by architecture into something greater than the sum. This is building in sound. For you, classical music serves as both inspiration and regulation. The structural complexity satisfies your mind; the harmony demonstrates the beauty possible when structure serves expression. Use classical music during planning phases to help your mind organize complex systems. Use it during execution to maintain focus and rhythm. Composers like Bach (supreme structural precision) and Beethoven (structure containing immense emotion) are particularly aligned with Builder frequency. Let their work remind you: structure is not the enemy of beauty. Structure is what makes beauty possible.',
    color_name: 'Brown',
    color_desc: 'Brown is the color of earth, wood, stone, and stability—the palette of the natural builder. It is not flashy because it does not need to be; it is foundational. Brown frequencies ground your energy into the physical realm and remind your system of what you are here to do: create form that lasts. Surround yourself with brown in your workspace and home—wood furniture, leather, earth tones, natural materials. These are not just aesthetic choices; they are functional anchors for Builder consciousness. When you need to make structural decisions or enter focused building phases, wear brown. When you feel ungrounded or scattered, visualize brown earth beneath you, supporting you, providing the foundation for everything you will create. Brown also teaches humility—it is the color of soil, of service, of what makes growth possible without demanding attention.',
    freq_name: '396 Hz',
    freq_desc: 'The frequency of liberation from fear and guilt—specifically, the fears that prevent building. 396 Hz works on the root chakra, addressing survival fears that can paralyze Builder function. Because building requires commitment, investment, and risk (what if it fails? what if it collapses? what if I waste resources?), Builders often carry deep fears that must be cleared for optimal function. This frequency releases those fears at the cellular level, creating the stable foundation from which confident construction becomes possible. Use 396 Hz when you feel hesitation about starting a building project, when fear of failure is blocking action, or when you need to reconnect with the fundamental stability that allows you to build. Combine with 528 Hz (creation frequency) to move from cleared fear into active construction.',
    geo_name: 'Cube',
    geo_desc: 'The Cube is the geometry of physical manifestation, stability, and the material realm. It represents the element of Earth and the capacity to create form that holds. Six faces, eight vertices, twelve edges—complete, stable, solid. The Cube is your geometric signature because it IS what you do: you create containers that hold, structures that stand, forms that persist. Meditate on the Cube when you need to strengthen your building capacity. Visualize yourself standing inside a Cube of light, grounded and stable. Use physical cubes in your environment—blocks, boxes, cubic crystals like pyrite—as anchors for your function. The Cube also teaches: each face is complete in itself, yet the whole is created by the relationship between faces. Your builds succeed when each component is sound AND properly related to every other component.',
    gid_in: 'Structural Scanning',
    gid_in_d: 'You perceive the world through a structural lens—automatically scanning any situation, system, or object for its foundational integrity. When you enter a room, you unconsciously assess the architecture. When you hear a business plan, you immediately identify what is load-bearing and what is decorative. When you meet a person, you sense the structure of their character. This is not judgment; it is perception. You simply SEE how things are built and whether they will hold. This gives you the ability to identify weakness before failure, to recognize quality construction, and to know where to reinforce. The shadow: you may miss beauty, emotion, or meaning because you are so focused on structure. You may seem cold when you are simply being perceptual. Mastery comes when you can scan for structure AND remain open to what structure contains.',
    gid_proc: 'Linear Logic',
    gid_proc_d: 'Your mind builds understanding the same way you build everything else: brick by brick, step by step, foundation first. This is not a limitation—it is a superpower for construction. While others leap to conclusions (sometimes correctly, often not), you construct understanding systematically, ensuring each level is stable before adding the next. This means you may be slower to reach conclusions, but your conclusions are reliable. Your understanding, once built, does not collapse. This processing style makes you excellent at project management, systems design, troubleshooting, and any task requiring sequential precision. The challenge: impatience with those who process differently, and difficulty with tasks that genuinely require intuitive leaps. Learn to trust that your linear process will get you there, even if others arrive by different routes.',
    gid_dec: 'Pragmatic Utility',
    gid_dec_d: 'You make decisions based on what works, what lasts, and what serves function. Aesthetics, emotions, and abstract principles are secondary to utility. This is not cold—it is clear. When you choose materials, you choose for durability. When you choose strategies, you choose for sustainability. When you choose relationships, you choose for stability and mutual support. This decision-making style creates lives and organizations that actually work, that do not collapse under pressure, that serve their intended purpose. The shadow: you may undervalue beauty, inspiration, and emotional truth, dismissing them as impractical. But the greatest builders know: utility and beauty are not opposites. The most functional designs are often the most elegant. Let your pragmatism be wise enough to include what feeds the soul.',
    gid_out: 'Blueprinting',
    gid_out_d: 'You communicate through plans, specifications, and structured documentation. When you understand something, your instinct is to create a blueprint others can follow. This is generous—you are creating the scaffolding for others to build upon. Your instructions tend to be clear, sequential, and complete (sometimes too complete—you may over-specify when others just need the main points). Lean into this gift. Document your processes. Create templates, frameworks, and how-to guides. Your blueprints become force multipliers, allowing others to build what you have built without requiring your constant presence. The challenge: learn to match your communication to your audience. Some people need complete blueprints; others need just the principles. Learn to offer both.',
    rel_align: 'You thrive in relationships built on stability, reliability, and tangible expressions of love. You need partners who show up consistently, who do what they say they will do, and who value the same foundations you value: home, family, security, practical partnership. Words of affirmation mean less to you than acts of service and physical presence. You build relationships the same way you build everything else—carefully, with attention to foundation, with an eye toward longevity. The ideal Builder partner appreciates structure, contributes to shared building projects (home, family, business), and provides the emotional stability that allows you to do your work. Avoid partners who are chaotic, unreliable, or allergic to commitment—they will destabilize everything you are trying to build.',
    rel_chal: 'Your primary relationship challenge is imposing structure on emotional territory where structure does not belong. You may try to "fix" or "organize" your partner\'s emotional life rather than simply witnessing it. You may become controlling in an attempt to create stability, not realizing that relationships require space and flexibility to breathe. Emotional conversations may frustrate you because they do not follow logical sequence and cannot be resolved with a plan. The work: learn that emotions are not problems to be solved but experiences to be shared. Your partner does not need a blueprint for their feelings; they need your presence. Practice listening without trying to fix. Practice allowing chaos in the emotional realm while maintaining structure in the practical realm. Relationships need both builders and space.',
    ritual_name: 'The Foundation Breath',
    ritual_steps: [
      'Stand barefoot on the earth, floor, or any stable surface. If possible, choose ground you have built upon or wish to build upon. Feel the solidity beneath you. This is where all building begins: stable ground.',
      'Begin Box Breathing: Inhale slowly for 4 counts, filling your lungs completely. Hold the breath for 4 counts, containing the energy. Exhale slowly for 4 counts, releasing completely. Hold empty for 4 counts, resting in stillness. This 4-4-4-4 pattern creates the internal structure that reflects your external gift.',
      'As you continue the Box Breath, begin to visualize roots extending from the soles of your feet deep into the earth. With each exhale, the roots grow deeper. With each inhale, you draw stability up from the ground. You are not separate from the earth—you are an extension of it, building upon it.',
      'Continue for at least 3 minutes, or until you feel profoundly stable and grounded. Notice that this stability is not rigid—it is rooted, like a tree that can sway in wind without toppling.',
      'When complete, stamp each foot once, firmly, declaring: "I am grounded. I am stable. I build what lasts." Carry this foundation into your building work.',
      'Use this ritual before beginning any construction project, before making structural decisions, or whenever you feel destabilized by chaos. The foundation you create internally mirrors the foundations you create externally.'
    ],
    vocation: 'Architect / Founder',
    cycle: 'Foundation',
    cycle_desc: 'The laying of groundwork that will support everything built upon it—you are designed to establish the base upon which others can construct.',
    summary_synthesis: 'Your power lies not in force, but in foundations. While others chase the fleeting spark of inspiration, you understand that sparks die without fuel, and fuel is useless without a hearth to contain it. YOU are the hearth. You are designed to lay the bricks of legacy, to create structures that will stand long after the initial excitement has faded, to do the patient and essential work of making dreams into reality. This is not glamorous, and you have likely felt undervalued in a world that celebrates visionaries and disruptors while ignoring those who actually build. But know this: every vision that manifests does so through Builder hands. Every disruption that lasts is stabilized by Builder foundations. The world needs your patience, your precision, your willingness to get it right rather than get it fast. Remember that the strongest structures are those that can bend without breaking—rigidity is not strength but brittleness. Build form that breathes, structure that serves life, foundations strong enough to support growth you cannot yet imagine. This is your sacred work.'
  },
  'Explorer': {
    contract: 'To map the unknown and expand the boundaries of collective experience by going where others fear to tread. You are the scout, the pioneer, the first one through the door into territories that have not yet been charted. This is not mere wanderlust or restlessness (though it can feel that way)—it is a sacred function. The collective cannot evolve into territories it cannot perceive, and YOU are the perceptual apparatus that extends into the unknown and reports back. Whether you explore physical geography, intellectual frontiers, consciousness states, relational dynamics, or creative territories, your function is the same: go further than others have gone, discover what is there, and bring back what you find. Without Explorers, humanity stays trapped in the known, recycling the same territory forever. You are the growing edge of human experience.',
    glitch_name: 'Drive Overload',
    glitch_desc: 'Your primary dysfunction is burnout caused by constant motion—the inability to stop exploring even when your system is depleted. This manifests as chronic restlessness (you feel anxious or depressed when stationary), inability to complete journeys (you abandon one exploration for the next before integrating what you found), fear of stillness (you unconsciously believe that if you stop moving, you will cease to exist), superficial engagement with many territories rather than deep engagement with any, and relationships left behind as you move toward the next horizon. You may find yourself exhausted but unable to rest, surrounded by half-finished maps, accumulating experiences without wisdom. The deeper pattern: you are running TOWARD the new to avoid something in the present or past. Your motion is not just exploration—it is also escape.',
    glitch_fix: 'Static Integration is your medicine—the deliberate practice of pausing to map and integrate the territory you have just covered before rushing to the next horizon. Specific practices: After any significant exploration (trip, project, learning phase), force yourself to stay still for a defined period. Document what you discovered. Let it settle. Create a "base camp" that you return to regularly—a physical place, a relationship, a practice—that grounds your wandering. When the urge to move arises, ask: "Am I moving toward something, or away from something?" If it is escape, stay. If it is genuine calling, go. Practice finding the unknown within the familiar—you can explore infinitely within a single relationship, a single place, a single idea if you go deep enough. Not all exploration is horizontal; some is vertical.',
    oil_name: 'Peppermint',
    oil_desc: 'Peppermint clears mental fog instantly, providing the sharp focus needed to navigate uncharted territory. It activates alertness without anxiety, clarity without tension—exactly the state you need when entering the unknown. For Explorers, peppermint serves as a reset button: when you feel overwhelmed by the complexity of new territory, when your senses are overloaded with novelty, one inhale of peppermint cuts through the noise and restores perceptual clarity. Use it before entering new environments, during travel, when learning complex new material, or any time you need your explorer senses at full capacity. Peppermint also stimulates the breath, and breath is how you regulate your nervous system during the activation that exploration requires. Keep peppermint with you always—it is your field tool.',
    crystal_name: 'Azurite',
    crystal_desc: 'Azurite is the stone of journeying—it activates the third eye for perception beyond the veil of the known. Its deep blue color resonates with the infinite, the unexplored, the territory that exists beyond current maps. For Explorers, Azurite enhances the perceptual capacities that make your function possible: pattern recognition in novel environments, intuition about where to go next, and the ability to perceive meaning in unfamiliar data. It also supports the integration phase of exploration—helping you make sense of what you have discovered and communicate it to others. Meditate with Azurite before expeditions. Hold it when processing discoveries. Place it on your third eye when you need to see what lies ahead. Azurite teaches: the unknown is not empty. It is full of pattern, meaning, and intelligence waiting to be recognized.',
    metal_name: 'Copper',
    metal_desc: 'Copper is the great conductor—it moves energy (and information) between different realms effortlessly. This is your function made metal. Copper allows you to move between territories, translating and transmitting what you find. It is also the metal of Venus, bringing beauty and harmony to exploration—reminding you that the point is not just to cover ground but to discover beauty in new territories. For Explorers, copper supports the nervous system during the stress of constant novelty. It facilitates communication between your discoveries and those who need to hear them. Wear copper jewelry, especially bracelets that contact pulse points, to maintain conductivity between inner and outer exploration. Copper also teaches: you are not just a consumer of experience but a conductor of it. What passes through you is meant to pass through you into the collective.',
    animal_name: 'Eagle',
    animal_desc: 'The Eagle is your spirit teacher because it represents absolute freedom of movement combined with precision of vision. Eagles see the entire landscape from heights others cannot reach, and they move through that landscape with sovereign grace. This is the Explorer ideal: not just wandering, but seeing clearly; not just moving, but moving with purpose toward what has been sighted. When Eagle appears in your life, it asks: Are you exploring with clear sight, or just moving blindly? Are you covering territory, or truly seeing it? Eagles are also solitary hunters—they do not follow the flock. This is your medicine: trust your own perception of where to explore next, even when others cannot see what you see. And remember, Eagles return to the nest. Even the most far-ranging explorer needs a home base.',
    music_name: 'World / Fusion',
    music_desc: 'World and fusion music resonates with Explorer consciousness because it is itself exploration made audible—the meeting of different traditions, the discovery of what happens when boundaries dissolve and separate territories combine. For you, this music serves as both inspiration and integration tool. It reminds you that exploration is fundamentally about CONNECTION—discovering that apparently separate territories are actually part of a larger whole. Use world music when planning expeditions, when processing cross-cultural experiences, when you need to remember why you explore. Let it teach you: the point of exploration is not conquest or collection but the discovery of underlying unity. Every new territory you map reveals another face of the same infinite reality.',
    color_name: 'Turquoise',
    color_desc: 'Turquoise is the bridge color—it lives between blue (sky, infinite, spirit) and green (earth, growth, embodiment). This is exactly where you operate: between the known and unknown, the mapped and unmapped, the familiar and foreign. Turquoise has been used by travelers and explorers across cultures precisely because it carries protective and clarifying energy for those who venture beyond boundaries. For you, turquoise serves as a visual anchor for your function. Wear it, surround yourself with it, visualize it when entering unknown territory. Turquoise teaches: you are the bridge. Your function is not just to explore but to connect territories that were separate before you arrived. You do not just discover—you unify.',
    freq_name: '528 Hz',
    freq_desc: 'The frequency of Miracles and DNA Repair—the so-called "Love Frequency" that supports transformation at the most fundamental level. For Explorers, 528 Hz serves a specific function: it helps your system adapt to the constant novelty that exploration requires. Every new territory changes you; every discovery rewrites some part of your operating system. 528 Hz supports this continuous evolution, helping your DNA (literally) adapt to new inputs. It also resonates with the heart, reminding you that exploration without love is mere consumption. Use 528 Hz before, during, and after expeditions. Let it help you process novelty without being overwhelmed. Let it remind you: you are not just finding new territories; you are becoming new through the finding.',
    geo_name: 'Octahedron',
    geo_desc: 'The Octahedron is the geometry of Air—the element of movement, communication, and mental integration. Its eight faces create a form that seems to float, to be in motion even while still. This is your geometric signature: even at rest, something in you is oriented toward the next horizon. The Octahedron also represents the integration of above and below, the joining of upward and downward pyramids into a unified form. For Explorers, this teaches: your discoveries must integrate both heights (inspiration, vision, possibility) and depths (grounding, embodiment, practical application). Meditate on the Octahedron when you need to balance expansion with integration. Visualize yourself at its center, receiving from all directions simultaneously. This is the integrated Explorer: not just moving outward, but receiving from everywhere.',
    gid_in: 'Perceptual Scanning',
    gid_in_d: 'You continuously scan your environment for novel patterns, changes, and opportunities for exploration. This happens automatically—your senses are always asking "What is new here? What has not been mapped? Where is the edge of the known?" This perceptual stance makes you extraordinary at noticing what others miss, detecting shifts before they become obvious, and finding the entry points to unexplored territory. It also makes you restless in familiar environments, because your scanning system finds nothing new to engage. Understanding this as a perceptual style (not a character flaw) helps you design your life to provide the novelty your system requires while also building in integration time. You are not flawed for needing the new; you are designed this way for a function.',
    gid_proc: 'Vector Analysis',
    gid_proc_d: 'Your mind naturally processes information by determining direction and velocity—where is this going, how fast is it moving, what trajectory does it suggest? This is explorer cognition: you are always calculating vectors, always sensing the paths through territory. When you receive new information, you immediately plot its implications: if this is true, then we can go THERE. This processing style makes you excellent at strategy, trend-spotting, and identifying opportunities before they become obvious. It also means you can become impatient with static information that does not suggest direction. Learn to value maps (static representation) as well as vectors (dynamic direction). Both are needed.',
    gid_dec: 'Impulse Calibration',
    gid_dec_d: 'Your decisions are made by trusting the visceral pull toward the new—a felt sense of "that way" that precedes logical analysis. This is not impulsivity (though it can look like it from outside); it is a genuine perceptual capacity. Your system can sense the call of unexplored territory before your mind can explain why. This decision-making style requires TRUST—trust that the pull is meaningful, trust that your explorer instincts have been refined by countless successful navigations. The work is calibration: learning to distinguish between genuine call and mere escape, between meaningful exploration and addictive novelty-seeking. With practice, you can trust your impulses precisely because you have learned to calibrate them.',
    gid_out: 'Signal Broadcasting',
    gid_out_d: 'You communicate by reporting findings from the edge—sending signals back from unexplored territory to those who remain in the known. This is dispatches from the frontier, not systematic analysis. Your communication tends to be immediate, vivid, experiential: "I am HERE, and this is what I see!" This style inspires others to explore, expands collective sense of possibility, and brings news that would otherwise never arrive. The challenge: your reports may lack the systematic organization that helps others actually use what you have discovered. Learn to balance vivid dispatches with organized cartography. Both spontaneous reporting and careful map-making are part of the Explorer function.',
    rel_align: 'You require a partner who is fundamentally self-sovereign—someone who has their own territory, their own purpose, their own explorations. The relationship must function as a Basecamp, not a Cage: a secure ground to return to, not a fence that limits movement. You need partners who are genuinely excited by your discoveries rather than threatened by your absences, who have their own richness of life rather than depending on yours, and who understand that your wandering is not rejection of them but expression of your nature. The ideal Explorer partner says "Tell me what you found" with genuine curiosity, holds the home fires without resentment, and has their own adventures to share when you return.',
    rel_chal: 'Your primary relationship challenge is the Flight Reflex—the instinct to run when emotions get heavy, when commitment deepens, when the relationship moves from exciting exploration to familiar territory. You may leave before you are left, move before you can be trapped, explore new connections rather than deepening existing ones. Intimacy itself can feel like a cage. The work: recognize that the deepest territory is INTERNAL, and relationships are one way to explore it. Staying is not stagnation—it is vertical exploration instead of horizontal. The person in front of you is infinite; you could explore them for a lifetime without reaching the edge. Practice finding the unknown within the known. Practice exploring depth, not just breadth.',
    ritual_name: 'Vector Calibration',
    ritual_steps: [
      'Stand facing physical North—use a compass if needed. This orients your body with the Earth\'s magnetic field and calibrates your internal compass to external reality. You are an instrument of exploration; instruments need calibration.',
      'Close your eyes and take three deep breaths, releasing any agenda or predetermined destination. You are about to ask a genuine question; you need to be empty enough to receive a genuine answer.',
      'Ask aloud: "Where is my magnetic north today?" This is not asking about physical direction—it is asking about the direction of your soul\'s exploration. Where is the frontier calling you right now? What territory wants to be discovered?',
      'Keeping your eyes closed, slowly turn your body in a full circle. Pay attention to sensations: pulls, resistances, openings, closings. At some point in the rotation, you will feel a sense of alignment—a "click," a yes, a rightness. This might be subtle; trust your perception.',
      'Stop when you feel the alignment. Open your eyes. You are now facing your current vector—the direction of exploration that is calling you today. It might be literal (a place to go) or metaphorical (a topic to research, a conversation to have, a skill to develop).',
      'Speak the vector aloud: "Today I explore toward _____." This declaration focuses your Explorer energy and commissions your perceptual system to scout in that direction. What you name, you empower.'
    ],
    vocation: 'Researcher / Pioneer',
    cycle: 'Expansion',
    cycle_desc: 'The breaking of boundaries and seeking of horizons—you are designed to extend beyond current limits into territory not yet known.',
    summary_synthesis: 'You are the cartographer of the new earth, the scout sent ahead to discover what lies beyond the edges of the map. Your restlessness is not a flaw to be fixed—it is the engine of discovery, the relentless pulse that drives you toward horizons others cannot see or fear to approach. Every territory humanity has claimed, every frontier that became familiar, was first explored by someone like you. This is your lineage, your function, your gift. But the gift becomes a curse when it runs without rest, when you confuse motion with progress, when you flee from rather than journey toward. When you learn to pause and integrate your findings, when you create base camps and return to them, when you map what you discover instead of just passing through, you transform from a wanderer into a wayfinder—one who not only explores but helps others follow. The deepest territory is internal; you could spend a lifetime exploring the landscape of a single relationship, a single practice, a single question. Do not mistake horizontal movement for the only kind of exploration. Learn to go deep as well as far. Then your exploring truly serves the whole.'
  },
  'Sage': {
    contract: 'To distill raw experience into universal wisdom and serve as the living archive of truth. You are the one who transforms the chaos of lived experience into patterns that can be understood, taught, and applied. While others experience life, you UNDERSTAND it—extracting the principles beneath the particulars, the laws beneath the events, the timeless beneath the temporal. This is not mere intellectualism or academic exercise; it is a sacred function. Without Sages, every generation would start from zero, wisdom would die with the wise, and humanity would be trapped in endless repetition of the same mistakes. You are the memory of the species, the pattern-recognizer, the one who sees the thread connecting past, present, and future. Your gift is not just knowing—it is knowing what is worth knowing, and making it accessible to those who need it.',
    glitch_name: 'Analysis Paralysis',
    glitch_desc: 'Your primary dysfunction occurs when you retreat into the mind to avoid the messiness of lived reality—thinking about the path instead of walking it. This manifests as endless research that never becomes action, accumulating knowledge without applying it, using intellectual complexity as a defense against emotional vulnerability, dismissing direct experience in favor of conceptual understanding, and becoming trapped in the library of your own mind while life happens outside. You may find yourself knowing exactly what should be done but unable to do it, understanding relationships theoretically but struggling to be present in them actually, analyzing feelings instead of feeling them. The deeper pattern: thinking has become a way to avoid the risk and rawness of direct engagement. Your library becomes your prison.',
    glitch_fix: 'Trust the intuitive leap and move before you have 100% of the data. This is counterintuitive for you—incomplete information feels dangerous—but it is exactly the medicine you need. Specific practices: Set a research limit for decisions, then choose regardless of whether you feel "ready." Daily, do something physical that requires no thought—dance, run, build with your hands. Practice the mantra: "I know enough to begin." When you catch yourself researching instead of acting, ask: "What am I avoiding by staying in my head?" Share your wisdom BEFORE it feels complete; let others\' feedback be part of the refinement. Remember: wisdom that is never applied is not wisdom at all—it is just information hoarding. The goal is not to know everything; it is to know enough to live well and help others do the same.',
    oil_name: 'Sage',
    oil_desc: 'The oil of your archetype, Sage clears distortions from the perceptual and cognitive field to allow for pure seeing. It has been used in purification ceremonies across cultures because it literally cleanses—energetically, it removes the noise that interferes with clear perception. For you, Sage oil serves as a clarifying agent: use it when you need to cut through complexity to essential truth, when your mind is cluttered with too much information, or when you need to purify your perception before engaging with important questions. Burn sage (smudging) to clear your study space. Apply the essential oil to your temples before research or teaching. Let Sage teach you: clarity comes not from accumulating more but from removing what obscures.',
    crystal_name: 'Lapis Lazuli',
    crystal_desc: 'Lapis Lazuli has been the stone of wisdom and truth since ancient Egypt, where it adorned pharaohs and was ground into ultramarine pigment for sacred art. Its deep blue flecked with gold pyrite represents the night sky full of stars—infinity made visible, knowledge scattered across vastness. For Sages, Lapis activates the third eye and throat chakra simultaneously, enhancing both perception of truth and capacity to communicate it. It supports the Sage function at every level: seeing patterns, understanding meaning, and transmitting wisdom to others. Wear Lapis when teaching or writing. Meditate with it when seeking understanding. Place it on your third eye when you need insight into complex problems. Lapis teaches: truth is not created, it is uncovered. Your function is not to invent wisdom but to perceive and transmit what is already true.',
    metal_name: 'Lead',
    metal_desc: 'Lead is the metal of Saturn—the planet of structure, time, limitation, and hard-won wisdom. It is dense, heavy, and transforms slowly. This resonates with Sage function because real wisdom is not light or easy—it is the heavy residue left after the dross of mere opinion has been burned away. Lead anchors high-voltage insight into practical reality; it keeps wisdom from becoming ungrounded abstraction. For you, lead energy teaches patience and weight: wisdom cannot be rushed, understanding takes time, and the most important truths are dense with meaning. Work with lead metaphorically (lead is toxic in physical form): appreciate Saturnian qualities of discipline, structure, and the slow accumulation of understanding that only time can provide. Your wisdom should have weight, not just sparkle.',
    animal_name: 'Owl',
    animal_desc: 'The Owl is the universal symbol of wisdom because it sees clearly through the dark—perceiving what is invisible to others. While the world sleeps in ignorance, the Owl is awake, watching, understanding. This is your medicine. When Owl appears in your life, it asks: Are you seeing clearly? Are you willing to look at what others avoid? Are you awake to patterns that are hidden in darkness? Owls are also silent flyers—they perceive without disturbing. This teaches the Sage: sometimes the deepest understanding comes from quiet observation, not active inquiry. Owls are solitary—they do not flock. This reflects the Sage path: the deepest wisdom often requires solitude, time apart from the noise of consensus reality. Finally, Owls digest slowly—they swallow whole and process internally. Let your understanding have time to digest before you speak.',
    music_name: 'Gregorian Chant / Sacred',
    music_desc: 'Gregorian Chant represents ancient harmonic patterns refined over centuries to transmit timeless wisdom through sound. These are not just songs—they are acoustic wisdom-transmission, designed to quiet the mind and open the capacity for higher perception. For Sages, this music serves as a reminder that wisdom is not new; it is ancient, transmitted across generations through various forms. The simplicity of chant (single melodic line, no harmony in the modern sense) teaches that the deepest truths are often the simplest. The sacred context reminds you that wisdom-seeking is not merely intellectual but spiritual—you are participating in something larger than yourself. Use sacred music during study, contemplation, or any time you need to connect with the timeless stream of wisdom that flows through all genuine seekers.',
    color_name: 'Indigo',
    color_desc: 'Indigo is the color of the third eye—the center of intuition, insight, and the perception of pattern and meaning. It sits between blue (throat, communication) and violet (crown, transcendence), perfectly positioned for the Sage function: perceiving truth and transmitting it. Indigo has depth—it is not a surface color but one that seems to recede infinitely, like the night sky or a deep pool. This reflects the nature of wisdom: the deeper you go, the more there is. Surround yourself with indigo in your study and contemplation spaces. Wear it when teaching or engaging in important intellectual work. Visualize indigo light filling your third eye when seeking understanding. Indigo teaches: wisdom has depth. Stay with questions long enough to find their bottom—if they have one.',
    freq_name: '852 Hz',
    freq_desc: 'The frequency of spiritual order—852 Hz awakens the capacity to see through illusion and perceive the underlying pattern of reality. For Sages, this frequency serves as a tuning fork for the third eye, enhancing the pattern-recognition and truth-perception that define your function. 852 Hz cuts through the noise of opinion, assumption, and distortion to reveal what is actually true. Use this frequency during research, contemplation, or any time you need to discern truth from falsehood. It is particularly useful when you feel confused by complexity or overwhelmed by information—852 Hz helps you find the signal in the noise. Combine with 963 Hz (connection to source) to access wisdom that transcends intellectual understanding.',
    geo_name: 'Dodecahedron',
    geo_desc: 'The Dodecahedron is the geometry of the fifth element—Ether, Spirit, the container of all other elements. Its twelve pentagonal faces represent the completion of a cycle, the integration of all knowledge into unified understanding. This is the geometric signature of the Sage: not just accumulating information in separate categories but integrating all knowledge into a coherent whole. Plato assigned the Dodecahedron to the heavens, suggesting it represents the organizing pattern of the cosmos itself. For Sages, meditating on this form supports the integration function—helping you see how disparate pieces of knowledge connect into larger patterns. The Dodecahedron teaches: true wisdom is not fragmented expertise but holistic understanding. Seek the unity beneath the diversity.',
    gid_in: 'Deep Archiving',
    gid_in_d: 'You absorb and store vast quantities of information with remarkable retention. Your mind functions like a library with sophisticated indexing—data goes in and remains accessible, cross-referenced with related information, available for retrieval when needed. This gives you a depth and breadth of knowledge that others find remarkable (and sometimes intimidating). Your archiving is not passive storage but active organization: as new information arrives, it is automatically categorized, connected to existing knowledge, and assessed for significance. The challenge: you may archive so much that retrieval becomes slow, or become so focused on collecting that you neglect applying. Your archive is valuable only if you can access and use it. Regularly review and synthesize what you have collected.',
    gid_proc: 'Pattern Synthesis',
    gid_proc_d: 'Your primary cognitive operation is connecting dots—perceiving the underlying patterns that link apparently separate pieces of information into coherent wholes. Where others see random events, you see meaningful sequences. Where others see isolated facts, you see principles. This synthesis function is the core of wisdom: extracting the general from the particular, the timeless from the temporal. Pattern synthesis allows you to predict outcomes (because you see the pattern that is unfolding), to advise wisely (because you see how current situations connect to past examples), and to teach effectively (because you can show how specific instances illustrate general principles). The challenge: sometimes you see patterns that are not actually there, or impose patterns on randomness. Check your syntheses against evidence.',
    gid_dec: 'Historical Resonance',
    gid_dec_d: 'You make decisions by checking current situations against historical patterns—asking "What happened before when conditions were similar?" This is not mere precedent-worship but genuine wisdom: if a pattern has repeated consistently across time, it is likely expressing something true about how reality works. Your decision-making draws on your vast archive, finding resonances between present situations and past examples. This gives your decisions weight and groundedness; you are not just reacting to the immediate but responding from deep knowledge. The challenge: the past does not always predict the future, and new situations may require new responses. Learn to balance historical wisdom with openness to genuine novelty. Sometimes the pattern is breaking, and that is the most important data of all.',
    gid_out: 'Transmission',
    gid_out_d: 'You communicate by distilling complexity into accessible wisdom—transmitting what you have learned in forms others can receive and apply. This is not just information sharing but genuine teaching: you do not just tell people what you know, you help them understand it for themselves. Your transmission tends to be structured, clear, and precise—you have already done the synthesis work, and you offer the result in organized form. The challenge: you may over-complicate (because you see so many nuances) or under-communicate (assuming others have context they lack). Learn to gauge your audience and adjust transmission accordingly. The goal is not to demonstrate your knowledge but to successfully transfer it.',
    rel_align: 'You thrive in relationships characterized by intellectual intimacy—partnerships where ideas can be shared, debated, and developed together. You need partners who can engage with your mental world, who are curious and thoughtful, who appreciate depth over superficiality. For you, a good conversation is a form of intimacy; sharing ideas is sharing yourself. The ideal Sage partner is themselves intellectually engaged (though not necessarily in the same fields), respects your need for contemplation and solitude, and can meet you in the realm of ideas while also helping you stay connected to embodied experience. Avoid partners who are threatened by your intelligence or dismissive of intellectual pursuits.',
    rel_chal: 'Your primary relationship challenge is intellectualizing feelings—retreating into analysis when emotional presence is required. You may discuss relationships rather than being in them, understand your partner\'s feelings without actually empathizing, or use intellectual frameworks to avoid the vulnerability of direct emotional engagement. Partners may feel that you are "in your head" rather than in the relationship, that you observe them rather than connect with them. The work: learn that emotions are not problems to be solved but experiences to be shared. Practice BEING WITH feelings (yours and others\') without immediately analyzing them. Let your vast knowledge include the knowledge that some things cannot be thought, only felt.',
    ritual_name: 'The Archive Silence',
    ritual_steps: [
      'Find a space of total silence—no electronics, no hums, no external noise. This may require ear protection or travel to a quiet natural setting. The goal is to create conditions where your inner knowing can be heard without interference.',
      'Sit comfortably, close your eyes, and begin to let your thoughts settle. Do not try to stop thinking—this creates more thought. Instead, imagine your thoughts as sediment in a glass of water that has been shaken. Simply let them settle naturally.',
      'As thoughts arise, let them pass without engagement. You are not meditating on anything—you are allowing the mental noise to quiet so that deeper knowing can emerge. This may take considerable time; Sage minds are active.',
      'Do not move. Do not speak. Simply sit until the water clears and you can see the bottom—until the surface noise quiets and you perceive what is beneath.',
      'When genuine silence is achieved (you will know it), ask one question—the question that most matters to you right now. Ask it clearly, then return to silence. The answer may come as words, images, feelings, or knowing. It may come later, after the practice ends.',
      'This practice serves the Sage function by creating conditions for wisdom that transcends intellectual understanding. Your archive is vast, but beneath it is a deeper knowing that only silence reveals.'
    ],
    vocation: 'Teacher / Philosopher',
    cycle: 'Reflection',
    cycle_desc: 'The turning inward to synthesize wisdom—you are designed to process experience into understanding and to transmit what you learn.',
    summary_synthesis: 'You are the keeper of the records, the one who remembers when others forget, who sees the pattern when others see only chaos. Your silence is not emptiness but fullness—a library waiting to be read, a vast archive of understanding accumulated across a lifetime of deep attention. Your task is not to hoard this wisdom but to transmit it: to translate the complexity of the universe into understanding that others can actually use. This means leaving your library sometimes, stepping out from the contemplative heights into the messy marketplace where wisdom is needed. It means sharing before you feel ready, teaching while you are still learning, and accepting that wisdom applied imperfectly is more valuable than wisdom hoarded perfectly. The world does not need your complete understanding; it needs your best current understanding, offered generously, refined by engagement. Analysis paralysis is not depth—it is fear. At some point, you know enough. At every point, you can help someone who knows less. Step out of the library. The world is waiting for what you carry.'
  },
  'Nurturer': {
    contract: 'To incubate growth and protect the seeds of consciousness until they can sustain themselves. You are the garden in which others grow, the womb in which potential becomes form, the safe harbor where the wounded can heal and the developing can develop. This is not a passive role—it requires tremendous energy, skill, and discernment. You do not simply accept everything; you create the conditions under which specific things can flourish. Your gift is knowing what each being needs to grow, providing it skillfully, and knowing when to withdraw support so that what you have nurtured can stand on its own. Without Nurturers, nothing that is born would survive, no wound would heal, no potential would be realized. You are the essential substrate of all growth, and this is sacred work that has been undervalued by cultures that prize disruption over cultivation.',
    glitch_name: 'Empathic Flood',
    glitch_desc: 'Your primary dysfunction is losing yourself in the needs of others—absorbing their emotions, carrying their pain, dissolving your boundaries until you cannot distinguish your own feelings from those of the people you nurture. This manifests as chronic exhaustion (you give until empty), codependent relationships (you need to be needed), enabling dysfunction (you "help" in ways that prevent others from growing), resentment (you give without receiving until you are depleted and bitter), and loss of self (you do not know who you are outside of your caregiving role). You may find yourself surrounded by people who take from you while you cannot name your own needs, feeling responsible for everyone\'s emotions, unable to let others struggle even when struggle is necessary for their growth. The deeper pattern: giving has become a way to avoid receiving, and caring for others has become a way to avoid caring for yourself.',
    glitch_fix: 'Reinforce the energetic membrane—set boundaries not as walls against love but as the container that makes love sustainable. Specific practices: Learn to say no without explanation or apology. Practice receiving—when someone offers help, take it, even when you could manage alone. Spend time alone, checking in with YOUR needs, YOUR feelings, YOUR desires—not in relation to others but as your own. Before helping, ask: "Is this help actually helpful? Will this support their growth or their dependence?" Create a daily practice that is entirely for you, that nurtures the nurturer. Learn the difference between empathy (feeling with) and absorption (taking on). You can care deeply without carrying. Boundaries are not betrayal—they are what allows you to keep caring without destroying yourself.',
    oil_name: 'Rose',
    oil_desc: 'Rose is the supreme oil of the heart—it opens the heart center to higher frequencies of love while simultaneously protecting against energetic drain. For Nurturers, Rose serves a dual function: it amplifies your natural capacity for compassion while helping you maintain the boundaries that prevent compassion from becoming consumption. Rose has been used across cultures to represent love because it IS love made aromatic—but notice that roses have thorns. This is significant: love includes protection, and healthy nurturing includes limits. Apply Rose over your heart before entering nurturing situations. Use it after caregiving to restore what you have given. Let Rose teach you that the most powerful love is boundaried love, and the sweetest giving comes from fullness, not depletion.',
    crystal_name: 'Rose Quartz',
    crystal_desc: 'Rose Quartz is the stone of unconditional love—but the deepest teaching of this crystal is that unconditional love INCLUDES love of self. This is crucial for Nurturers: you cannot truly nurture others from emptiness, and the love you give must include love of the giver. Rose Quartz gently opens the heart, heals wounds related to giving and receiving, and teaches the boundary within compassion. For you, Rose Quartz serves as a reminder and a regulator. Wear it over your heart. Hold it when you feel depleted. Sleep with it under your pillow to let its gentle energy restore you while you rest. When you feel the pull to give past your limits, let Rose Quartz remind you: you matter too. Your needs are not less important than theirs. Love includes you.',
    metal_name: 'Silver',
    metal_desc: 'Silver is the metal of the Moon—the luminary that reflects light rather than generating it, that governs cycles and tides and emotions. For Nurturers, Silver resonates with your reflective, receptive nature and your connection to the rhythms that govern growth. Silver is also historically associated with healing and protection against negative energy. For you, Silver serves as an energetic buffer: it reflects back what is not yours while maintaining your sensitivity to what IS relevant. Wear Silver jewelry, especially near the heart or on the hands (which do so much of your nurturing work). Silver teaches: you can be reflective without being absorptive. You can be sensitive without being porous. You can be lunar without losing yourself in others\' light.',
    animal_name: 'Bear',
    animal_desc: 'The Bear is your spirit teacher because it embodies fierce nurturing—tender with its cubs AND dangerous to threats. This is the integration you need: gentleness and strength, softness and boundaries, love and protection. Bears also hibernate—they give and give during the active seasons, then withdraw completely to restore. This is crucial medicine for Nurturers: you need seasonal withdrawal, times when you are simply unavailable to nurture anyone but yourself. When Bear appears in your life, it asks: Are you protecting what you love (including yourself)? Are you resting enough to sustain your giving? Are you being fierce when fierceness is needed? Bears teach: true nurturing includes the capacity to say NO, to growl when boundaries are crossed, to retreat into the cave when the season requires. Hibernation is not selfishness—it is what makes the next season of nurturing possible.',
    music_name: 'Folk / Acoustic',
    music_desc: 'Folk and acoustic music carries the energy of intimate storytelling, of human voices and handmade instruments, of traditions passed down through nurturing relationships. This music is made in living rooms and around fires, not in stadiums; it is shared, not performed. For Nurturers, folk music resonates because it IS nurturing made audible—songs that comfort, stories that connect, melodies that soothe. Use this music to restore yourself after giving. Let it nurture you through your ears while you rest. Play acoustic music in your home to create a nurturing atmosphere. Folk music teaches: nurturing has been happening for all of human history, and you are part of that unbroken lineage of those who tend, comfort, and help things grow. You are not alone in this work.',
    color_name: 'Pink',
    color_desc: 'Pink is the universal love frequency—gentler than red\'s passion, warmer than white\'s purity. It represents compassion, tenderness, emotional healing, and the soft strength of the open heart. For Nurturers, pink serves as both amplifier and regulator: it enhances your natural capacity for compassion while keeping that compassion in the heart register rather than letting it overwhelm your entire system. Surround yourself with pink in your personal spaces—not necessarily in your caregiving spaces (where others\' needs determine the atmosphere) but in your private restoration zones. Wear pink when you need to remember that nurturing yourself is nurturing. Visualize pink light filling your heart after giving, restoring what you have poured out. Pink teaches: softness is not weakness. Gentleness is a power.',
    freq_name: '639 Hz',
    freq_desc: 'The frequency of harmonizing relationships and resolving dissonance—639 Hz works on the heart chakra to create coherence between self and other. For Nurturers, this frequency addresses your core challenge: maintaining connection without losing yourself. 639 Hz helps establish healthy energetic boundaries while keeping the heart open; it resolves the false dichotomy between loving others and protecting yourself. Use this frequency when relationships feel disharmonious, when you are struggling to set boundaries without guilt, or when you need to restore after giving. 639 Hz teaches: harmony includes both notes. A chord requires distinct tones maintaining their own frequency while blending with others. Your wellbeing is not separate from the wellbeing of those you nurture—it is part of the same harmony.',
    geo_name: 'Icosahedron',
    geo_desc: 'The Icosahedron is the geometry of Water—the element of emotion, flow, creativity, and nurturing. Its twenty triangular faces create a form that seems to flow even while still, approximating a sphere (the shape of the womb, of the cell, of containment). This is your geometric signature: the perfect container for emotional flow, holding space without rigidity, shaping without controlling. For Nurturers, the Icosahedron represents the ideal: firm enough to contain, flexible enough to flow, dynamic yet stable. Meditate on this form when you need to strengthen your capacity to hold space for others. Visualize yourself as an Icosahedron, receiving flow from all directions while maintaining your own structure. The Icosahedron teaches: containment and flow are not opposites. The best nurturing holds enough to be safe and opens enough to allow growth.',
    gid_in: 'Empathic Absorption',
    gid_in_d: 'You receive information primarily through feeling—sensing emotions, energies, and needs directly through your own body and energy system. When someone near you is in pain, you feel pain. When they are joyful, you feel joy. This is not imagination—it is a genuine perceptual capacity that allows you to know what others need without them having to articulate it. This makes you exquisitely attuned to the beings you nurture; you sense what they require at levels they may not even be conscious of. The challenge: absorption is different from perception. You can sense without taking on, feel without carrying. This distinction is crucial. Without it, your gift becomes your wound, and you drown in others\' emotions while losing track of your own.',
    gid_proc: 'Harmonic Filtering',
    gid_proc_d: 'Your mind processes incoming information by checking it against a fundamental question: Is this safe? Is this supportive of growth? Your filtering system is designed to identify threat and nurture-opportunity simultaneously. This makes you excellent at creating safe spaces, identifying subtle dangers, and knowing what each being needs to flourish. Your processing tends to prioritize relational and emotional data over abstract or conceptual information—you may miss logical details while catching emotional nuances others overlook. The challenge: your safety-filters may become overactive, seeing threat where there is none, or may include others\' safety while excluding your own. Learn to filter FOR yourself as skillfully as you filter for others.',
    gid_dec: 'Heart Resonance',
    gid_dec_d: 'Your decisions are made through the heart—not emotionally (in the sense of impulsively) but through a felt sense of what is caring, what is kind, what serves growth. When a decision resonates with your heart, it feels warm, expansive, alive. When it does not, you feel contraction or discomfort, even if it makes logical sense. This decision-making style keeps you aligned with your nurturing function; you consistently choose what serves growth and healing. The challenge: your heart may not distinguish between caring for others and caring for yourself, and may consistently choose others. Practice including yourself in the circle of beings your heart cares for. You are not outside the care you offer.',
    gid_out: 'Nutrient Flow',
    gid_out_d: 'You communicate through providing what is needed—emotionally, energetically, practically. Your speech tends to be supportive, encouraging, validating; you naturally attune to what the listener needs to hear and offer it. This makes you a natural counselor, encourager, and safe space provider. People feel held by your communication. The challenge: you may withhold truth that is needed but not wanted, prioritizing comfort over growth. Learn that sometimes the most nurturing thing is honest feedback, even when it is uncomfortable. Nutrient flow includes fiber, not just sugar. The deepest nurturing serves growth, and growth sometimes requires challenge.',
    rel_align: 'You thrive in relationships characterized by reciprocal care—partnerships where nurturing flows both directions, where your needs are held with the same attentiveness you offer, where you are cared for as skillfully as you care. This is not optional; it is essential for sustainable nurturing. You need partners who notice what you need (since you may not ask), who actively give (since you tend to focus on receiving others\' needs), and who protect you from over-giving (since you may not protect yourself). The ideal Nurturer partner is themselves capable of nurturing, attentive to your needs, and willing to insist that you receive, even when you resist.',
    rel_chal: 'Your primary relationship challenge is over-giving—pouring out until you are empty, then becoming resentful or exhausted, then feeling guilty about the resentment, then giving more to compensate. This cycle is destructive. You may also attract those who want to be nurtured but not to nurture, creating one-directional relationships that drain you. You may enable others\' dysfunction by making it comfortable, preventing the discomfort that would motivate their growth. The work: learn that your needs matter exactly as much as theirs. Practice asking for what you need—out loud, clearly, without apology. Let some things be uncomfortable if discomfort serves growth. Let some people go if they cannot or will not reciprocate. Your nurturing is a gift, not an obligation; give it where it grows something, not where it only feeds dependency.',
    ritual_name: 'The Membrane Shield',
    ritual_steps: [
      'Stand or sit comfortably in a quiet space. Close your eyes and take several deep breaths, bringing your attention fully into your body. Feel the boundary of your skin—the membrane that separates inside from outside.',
      'Visualize a shimmering silver bubble completely surrounding your body, about arm\'s length away in all directions. This bubble is permeable—love and connection can flow through it—but it is definite. It exists. It has substance.',
      'Inhale slowly, visualizing fresh, clear light flowing into the bubble from above. This is replenishing energy, sustenance for the nurturer. Let it fill your space.',
      'Exhale slowly, visualizing gray static—others\' emotions you have absorbed, energy that is not yours—flowing out of the bubble and being neutralized. You are not sending it back to anyone; you are simply releasing what is not yours.',
      'Continue the breath cycle until you feel clear, contained, and boundaried. Your capacity to sense others remains, but you are no longer absorbing.',
      'To complete, physically trace the boundary of your body with your hands—starting at the crown of your head, down your face, down your torso, down your legs, back up. As you trace, speak or think: "This is me. That is you. I can love you without carrying you. I can nurture without dissolving."',
      'Use this ritual daily, especially before and after caregiving situations. The membrane is not a wall—it is what allows you to keep loving sustainably.'
    ],
    vocation: 'Healer / Mentor',
    cycle: 'Cultivation',
    cycle_desc: 'The tending to what has been planted—you are designed to nurture growth through all its stages, from seed to fruition.',
    summary_synthesis: 'You are the garden in which others grow, the womb where potential becomes form, the safe harbor where wounds can heal and development can occur. This is sacred work, essential work, work that has been undervalued by a culture obsessed with disruption and individual achievement. But nothing that is born survives without nurturing. Nothing that is wounded heals without care. Nothing that is potential becomes actual without patient, skillful tending. YOU do this work. However—and this is crucial—a garden without a fence is trampled. A womb that never closes is depleted. A harbor that accepts every ship sinks under the weight. Your highest evolution comes when you realize that your boundaries are not walls against love but the necessary container for your love to exist sustainably. You cannot nurture from empty. You cannot give what you do not have. The most radical act of nurturing is learning to nurture yourself with the same skill and attentiveness you offer everyone else. Let yourself receive. Let yourself rest. Let yourself be tended. Then, from fullness rather than depletion, let your nurturing pour out into a world that desperately needs exactly what you offer.'
  },
  'Rebel': {
    contract: 'To disrupt stagnation and shatter obsolete structures so that new life can emerge. You are the lightning that clears dead wood, the earthquake that topples what has outlived its foundation, the immune response that attacks what no longer serves the body. This is not destruction for its own sake—it is destruction in service of evolution. Every system, belief, institution, and pattern eventually calcifies, becomes rigid, begins to serve its own perpetuation rather than its original purpose. YOU are the force that breaks these calcified structures open, liberating the energy trapped within them for new formation. Without Rebels, societies stagnate, relationships fossilize, individuals become trapped in patterns that slowly kill them. Your function is sacred, necessary, and perpetually uncomfortable for those invested in the status quo.',
    glitch_name: 'Reactionary Loop',
    glitch_desc: 'Your primary dysfunction is rebelling against everything without building anything—getting addicted to the fight, to the identity of being "against," to the righteous fury of destruction without ever transitioning to the harder work of creation. This manifests as chronic opposition (you are against things you have not examined simply because they are established), identity fusion with rebellion (you do not know who you are without something to fight against), relationships defined by conflict (you cannot tolerate peace or agreement), inability to commit to building (because building requires staying, and staying feels like conformity), and burning bridges that you actually need. You may find yourself exhausted by constant battle, isolated by your combativeness, or secretly empty because opposition does not actually fulfill you—it just keeps you busy.',
    glitch_fix: 'Create the new, do not just destroy the old. This is the evolution from Rebel to Revolutionary—from reactive destruction to proactive creation. Specific practices: For every structure you want to destroy, articulate what should replace it. Before attacking, ask: "Am I against this because it is harmful, or because I need something to oppose?" Build something—anything—that requires commitment, maintenance, and staying. Practice agreeing, supporting, and joining; notice how this feels. Find the rebellion within building: creating something genuinely new IS rebellious, often more so than merely destroying. When you feel the urge to tear down, channel that energy into construction. The goal is not to stop being disruptive but to ensure your disruption serves emergence, not just destruction.',
    oil_name: 'Eucalyptus',
    oil_desc: 'Eucalyptus breaks up stagnant energy patterns with its sharp, clearing scent. It is the aromatic equivalent of what you do: cutting through stale air, disrupting stuck patterns, creating space for fresh circulation. For Rebels, Eucalyptus serves as both affirmation and medicine. Use it when you need to clear space—physically, energetically, mentally. Diffuse it when beginning disruptive work to sharpen your focus. But also use it when YOUR energy has stagnated, when your rebellion has become routine, when you are stuck in old oppositional patterns. Eucalyptus does not discriminate—it clears ALL stagnation, including yours. Let it teach you: the same force that disrupts external calcification can disrupt internal rigidity. Stay fresh, stay moving, stay open to having your own assumptions challenged.',
    crystal_name: 'Black Tourmaline',
    crystal_desc: 'Black Tourmaline is the supreme protective and transformative stone—it absorbs negative energy and transmutes it into usable form. For Rebels, this is essential medicine. Your work brings you into contact with dense, stuck, sometimes hostile energy; without protection, you absorb what you are trying to clear. Black Tourmaline creates a shield that allows you to engage with dysfunctional systems without being poisoned by them. It also grounds the electrical energy that rebellion generates; Rebels often carry intense charge that needs earthing. Wear Black Tourmaline daily, especially when engaging in disruptive work. Hold it when you feel overwhelmed by the density of what you are fighting. Place it at the entrance of your home to protect against the blowback that rebellion attracts. Black Tourmaline teaches: you can engage with darkness without becoming dark.',
    metal_name: 'Steel',
    metal_desc: 'Steel is iron that has been refined through heat and pressure into something stronger, sharper, and more versatile. This is the Rebel trajectory: raw disruptive force refined into precise, effective intervention. Steel cuts cleanly; it does not just smash. For Rebels, steel represents the evolved form of your function—disruption that is targeted, effective, and discriminating rather than chaotic and indiscriminate. Steel is also made, not found—it requires process, skill, and intention. This teaches: your most effective rebellion is not raw reaction but refined response. Take your fire and forge it. Let experience sharpen your edge. The mature Rebel cuts precisely, wasting nothing, striking exactly where the cut will create maximum liberation.',
    animal_name: 'Wolf',
    animal_desc: 'The Wolf is your spirit teacher because it embodies intelligent disruption—the ability to operate both within the pack and as a lone hunter, to challenge hierarchies when necessary while also maintaining deep loyalties. Wolves have been feared and persecuted precisely because they represent a threat to the tame, the domesticated, the controlled. This is your medicine. When Wolf appears in your life, it asks: Are you rebelling intelligently, or just wildly? Do you know when to run with the pack and when to hunt alone? Are you loyal to anything, or only against everything? Wolves teach that rebellion and belonging are not opposites—the wolf is fiercely loyal to its pack while being wild. Find your pack. Be loyal. And from that base of belonging, let your wildness disrupt what needs disrupting.',
    music_name: 'Punk / Industrial',
    music_desc: 'Punk and Industrial music carry the raw disruptive energy of rebellion—they are loud, challenging, uncomfortable, and designed to shatter complacency. This is your soundtrack. For Rebels, this music serves as affirmation and amplification: when you need to access your disruptive fire, it is fuel. But it also serves as containment—sometimes the energy needs to be expressed through listening rather than acting. Let the music hold your fire when the fire needs holding. Use aggressive music to charge up before disruptive work, and to discharge after. But also notice: the best punk is not just against something—it expresses a genuine alternative, a vision, a yes beneath the no. Let the music teach you: authentic rebellion includes creation, not just destruction.',
    color_name: 'Red',
    color_desc: 'Red is pure activation energy—the color of blood, fire, urgency, and immediate transformation. It represents the life force in its most urgent expression, demanding attention, refusing to be ignored. For Rebels, red resonates with your function: you are the urgent disruption that cannot be overlooked, the alarm that sounds when systems are failing, the inflammatory response that attacks what threatens life. Use red to activate your disruptive capacity when action is needed. Wear it, surround yourself with it, visualize it when you need to amplify your fire. But balance red with cooling colors (blue, green) in your everyday environment—constant activation leads to burnout. Red is for action, not for rest. Know when to turn the red up and when to turn it down.',
    freq_name: '417 Hz',
    freq_desc: 'The frequency of undoing situations and facilitating change—417 Hz works on the sacral chakra to break up crystallized patterns and create space for new forms. For Rebels, this frequency supports your function directly: it softens what is rigid, dissolves what is stuck, and creates the energetic conditions for transformation. Use 417 Hz before engaging in disruptive work to prepare the field. Use it when you feel your own patterns calcifying, when your rebellion has become routine. Play it in spaces that feel stuck. 417 Hz teaches: disruption begins in the energetic realm before it manifests physically. Work on all levels—energy, thought, action—for maximum effectiveness.',
    geo_name: 'Lightning Bolt',
    geo_desc: 'The Lightning Bolt is not one of the Platonic solids—it is directional discharge, the geometry of breakthrough, the shape of sudden illumination and destruction combined. This is your geometric signature: not stable form but dynamic release, the concentrated discharge of accumulated potential into a single, shattering strike. For Rebels, the Lightning Bolt teaches several things: Lightning is not continuous—it is punctuated, intense, and followed by silence. Your disruption should follow this pattern: intense intervention followed by rest and observation. Lightning follows the path of least resistance to ground—your most effective rebellion finds the path of maximum impact with minimum wasted energy. Lightning illuminates even as it destroys—let your disruption reveal truth, not just create chaos.',
    gid_in: 'Friction Detection',
    gid_in_d: 'You perceive the world through a friction lens—automatically detecting where systems are stuck, where energy is trapped, where patterns have become rigid and are no longer serving life. When you enter a room, you sense where the dysfunction lives. When you hear a plan, you immediately spot the unexamined assumptions. When you meet a person, you feel where they are trapped. This is not negativity—it is accurate perception of calcification. Your friction detection allows you to identify intervention points, to know where disruption will be most effective. The challenge: you may become so focused on what is stuck that you miss what is flowing, so attuned to dysfunction that you overlook health. Balance your friction detection with appreciation for what works.',
    gid_proc: 'Inversion Logic',
    gid_proc_d: 'Your mind naturally inverts assumptions—taking whatever is accepted and asking "What if the opposite were true?" This is the cognitive engine of rebellion: the capacity to see that what everyone takes for granted may be arbitrary, wrong, or no longer relevant. Inversion logic allows you to identify hidden assumptions, to question what others do not even know they believe, to imagine alternatives that are invisible from within the dominant paradigm. This processing style makes you invaluable for innovation, for identifying blind spots, for preventing groupthink. The challenge: not every inversion is true or useful. Sometimes the accepted assumption is correct. Learn to discriminate between assumptions that need challenging and assumptions that have earned their acceptance.',
    gid_dec: 'Catalytic Spark',
    gid_dec_d: 'Your decisions are made by moving toward resistance—sensing where your energy will have maximum disruptive impact and choosing that direction. When something in you says "that needs to be challenged," you trust it and act. This is not impulsivity; it is accurate perception of where intervention is needed. Your catalytic spark identifies the pressure points, the leverage points, the places where a small amount of disruptive energy can shift a large system. The challenge: moving toward resistance means moving toward conflict, and this can become addictive. Learn to distinguish between resistance that indicates necessary disruption and resistance that indicates you should choose a different battle. Not every wall needs tearing down.',
    gid_out: 'Shockwave',
    gid_out_d: 'You communicate through provocation, challenge, and disruption—your words and actions create shockwaves that force response. You cannot be ignored; you demand engagement. This is effective for breaking denial, forcing recognition of problems, and catalyzing change. People remember what you say because it disrupts their comfortable assumptions. The challenge: shockwave communication can alienate, trigger defensive reactions, and close the very minds you are trying to open. Learn when to shock and when to persuade. Not everyone responds to provocation; some need to be invited, not challenged. Let your shockwaves be strategic, not reflexive.',
    rel_align: 'You thrive in relationships that include friction as a catalyst—partnerships where challenge is welcomed, where both parties grow through creative conflict, where stagnation is disrupted by honest engagement. You need partners who can handle your intensity, who do not take challenge personally, and who bring their own fire to the dynamic. The ideal Rebel partner is themselves alive and growing (not looking to you to provide all the energy), capable of fighting fairly and making up fully, and secure enough to not be threatened by your wildness. Avoid partners who need peace at any cost or who experience your challenges as attacks.',
    rel_chal: 'Your primary relationship challenge is creating turbulence that destroys rather than enlivens—fighting without repair, challenging without supporting, disrupting the stability that relationships need to survive. You may become combative when you are actually afraid of intimacy, using conflict to maintain distance. You may be unable to tolerate periods of peace, manufacturing problems when things are going well. You may choose partners to rebel against, creating relationships defined by opposition. The work: learn that relationships need stability AND challenge, and that your rebel function should serve the relationship\'s growth, not undermine its foundation. Not everything needs disrupting. Sometimes the most rebellious act is choosing peace.',
    ritual_name: 'The Break',
    ritual_steps: [
      'Find a private space where you can move freely and make noise without inhibition or concern for others. This ritual requires your full, unfiltered expression.',
      'Stand with feet wide, knees soft, arms loose. Take several deep breaths, bringing awareness to any stagnation in your own body and energy system. Where are YOU stuck? What patterns have YOU calcified into?',
      'Begin to shake your body—starting gently, then building intensity. Shake every part: hands, arms, shoulders, torso, hips, legs, feet. Let the shaking become chaotic, uncontrolled, wild. You are physically breaking up stuck energy.',
      'As you shake, allow sound: growling, screaming, wordless vocalization. Let the sound express what wants to break. Do not perform or control it; let it emerge. This is the shockwave of your system releasing crystallization.',
      'Continue shaking and sounding until you feel a natural release—a moment where something breaks and energy flows freely. This might be tears, laughter, stillness, or simply exhausted peace.',
      'Stop suddenly. Stand completely still. Feel what has shifted. Notice the space that has been created. This emptiness is not failure—it is possibility. Disruption creates space; creation fills it.',
      'Complete by asking: "What wants to be built in this space?" Let the answer arise without forcing it. You have done the breaking; now listen for the building.',
      'Use this ritual regularly to prevent your own calcification, and before engaging in disruptive work to ensure you are acting from clarity rather than personal stuckness.'
    ],
    vocation: 'Innovator / Disruptor',
    cycle: 'Disruption',
    cycle_desc: 'The breaking of old patterns to liberate truth—you are designed to shatter what has calcified so that new life can emerge.',
    summary_synthesis: 'You are the lightning that clears the dead wood, the storm that topples what no longer stands on solid ground, the sacred force of disruption that prevents stagnation from becoming permanent. While others fear the storm, you ARE the storm—and this is not a flaw but a function. Every system that has outlived its purpose, every pattern that has become a prison, every institution that serves itself rather than its mission, is waiting for someone like you to break it open. This is noble work. But lightning that strikes without purpose is just destruction; storms that never pass are not cleansing but devastating. Your mission is not just to break the old but to illuminate the path for the new structure to emerge. The most powerful rebellion is not perpetual opposition but targeted disruption followed by committed building. After you shatter the calcified form, stay to help with what comes next. Anyone can tear down; the evolved Rebel knows that the true revolution is building something genuinely new in the space that destruction creates. Let your fire forge, not just burn.'
  },
  'Leader': {
    contract: 'To direct energy and hold the frequency for the group—to be the organizing center around which collective effort coheres. You are not here to do everything yourself; you are here to create the conditions under which many can do their best work toward a shared aim. Leadership in this sense is not about power over others but power with and power for: the capacity to perceive the optimal direction, to communicate it compellingly, to align diverse contributions toward coherent outcomes, and to maintain the vision when others waver. Without Leaders, groups fragment into chaos, energy dissipates without direction, and potential remains unrealized for lack of focus. Your function is to be the sun around which planets orbit—not because the sun is "better" than planets, but because orbital systems require a gravitational center.',
    glitch_name: 'Control Fatigue',
    glitch_desc: 'Your primary dysfunction is micro-managing everything due to a fundamental lack of trust—exhausting yourself trying to hold every detail, control every outcome, and direct every action. This manifests as inability to delegate (because you believe only you can do it right), chronic overwork (because you take on what should be distributed), bottlenecking (everything waits for your approval), team disempowerment (they stop taking initiative because you always intervene), and eventual burnout (you cannot sustain being the only engine). You may find yourself surrounded by passive followers who have learned that their initiative will be overridden, feeling alone even while leading many, exhausted but unable to let go. The deeper pattern: control is a response to anxiety, and your anxiety about outcomes has become so intense that you cannot tolerate the uncertainty inherent in trusting others.',
    glitch_fix: 'Delegate the flow and trust the current. This requires confronting your underlying anxiety and choosing faith in others even when that faith feels risky. Specific practices: Identify tasks that ONLY you can do, and delegate everything else—even if others will do it differently than you would. Set clear outcomes but release control of methods; tell people WHAT success looks like, then let them figure out HOW. When you feel the urge to intervene, pause and ask: "Is this intervention necessary, or is it my anxiety?" Practice allowing mistakes as learning opportunities rather than crises requiring your control. Develop your people so they CAN be trusted with more; control is sometimes a response to genuine capability gaps that you have failed to address. Remember: the goal is not a group that needs you for everything but a group that functions excellently whether you are present or not. That is leadership success.',
    oil_name: 'Bergamot',
    oil_desc: 'Bergamot empowers confidence and directs energy—it activates the solar plexus (seat of will and personal power) while maintaining warmth and approachability. For Leaders, Bergamot serves a dual function: it enhances your capacity to project authority while keeping that authority from becoming harsh or cold. Leadership requires both strength and warmth, command and compassion; Bergamot supports this integration. Use Bergamot before leadership situations—meetings, presentations, difficult conversations—to align your energy with your role. Apply to the solar plexus to activate will without aggression. Diffuse it in spaces where you lead to create an atmosphere that is both directed and welcoming. Bergamot teaches: authority can be warm. Strength does not require coldness.',
    crystal_name: 'Citrine',
    crystal_desc: 'Citrine is the stone of manifestation and personal power—it carries solar energy that activates the will and supports the translation of intention into reality. For Leaders, Citrine resonates with your core function: you are the will at the center of the group, the intention that organizes effort, the manifestation engine that turns vision into outcome. Citrine enhances this capacity while also keeping your energy clear; unlike many power stones, Citrine does not hold negative energy but transmutes it. Wear Citrine, especially near your solar plexus, to enhance your leadership capacity. Keep it on your desk where decisions are made. Hold it when you need to project authority or make difficult calls. Citrine teaches: personal power is not taken, it is radiated. You do not need to dominate to lead; you need to shine clearly enough that others can orient by your light.',
    metal_name: 'Bronze',
    metal_desc: 'Bronze is an alloy—copper and tin combined to create something stronger than either alone. This is a perfect metaphor for leadership: you combine different elements (people, resources, ideas) into something more powerful than any single component. Bronze has been the metal of leaders since ancient times, used for statues of commanders, for ceremonial objects of authority, for tools that shaped civilizations. For Leaders, Bronze represents the enduring power of well-organized collective effort. Its warm golden color combines the solar authority of gold with the groundedness of copper. Work with Bronze symbolically: appreciate bronze objects, note the strength-through-combination they represent. Bronze teaches: your leadership is not about your individual strength but about your capacity to alloy diverse strengths into coherent power.',
    animal_name: 'Lion',
    animal_desc: 'The Lion is the universal symbol of leadership—solar authority, courage, and the willingness to take responsibility for the pride. But notice: lions do not lead by constantly hunting. They lead by maintaining sovereign presence that organizes the group, by acting decisively when action is needed, and by protecting what is theirs. Lions rest confidently, roar when necessary, and fight only when fighting is required. This is your medicine. When Lion appears in your life, it asks: Are you leading from sovereign presence or from anxious control? Are you confident in your authority or constantly proving it? Are you protecting your people or draining yourself trying to do their work? Lions teach: authority comes from being, not just doing. Your presence should be enough to organize the field; if it is not, no amount of action will compensate.',
    music_name: 'Epic / Cinematic',
    music_desc: 'Epic and cinematic music carries the energy of grand collective endeavor—orchestras coordinating dozens of musicians into unified emotional impact, soundtracks that inspire and direct the viewer\'s experience. This is leadership made audible: many parts contributing to a coherent whole, individual excellence serving collective impact. For Leaders, this music serves as inspiration and reminder: listen to it when you need to access your capacity for grand vision, when you need to remember why leadership matters, when you feel reduced to mere management. Let epic music remind you that leadership at its best is participation in something larger than any individual, the creation of experiences and outcomes that no single person could achieve. You are the conductor; let the music remind you what a well-conducted orchestra can create.',
    color_name: 'Gold',
    color_desc: 'Gold is the color of solar authority—the sun that shines on all, the light by which others navigate, the radiance that illuminates and warms. Gold has represented leadership across virtually all human cultures because it IS the frequency of sovereign presence: generous, radiant, and unwavering. For Leaders, gold resonates with your function: you are meant to be a sun, not a black hole. Your leadership should warm and illuminate, not drain and dominate. Wear gold to enhance your sovereign presence. Surround yourself with gold accents in spaces where you lead. Visualize golden light radiating from your solar plexus when you need to project authority. Gold teaches: true authority gives more than it takes. It shines for others\' benefit, not for its own glory.',
    freq_name: '741 Hz',
    freq_desc: 'The frequency of awakening intuition and expression—741 Hz works on the throat chakra to support clear, powerful communication, which is essential for leadership. Leaders must communicate vision, direction, feedback, and decisions; blocked or unclear expression undermines authority. This frequency also supports intuitive knowing, helping you perceive what the situation requires and express it effectively. Use 741 Hz before important communications, when preparing for leadership challenges, or when you feel your voice is not being heard. It helps dissolve blockages that prevent clear expression. 741 Hz teaches: your leadership is only as effective as your communication. The vision in your head is useless if it cannot travel clearly through your voice into others\' understanding.',
    geo_name: 'Pyramid',
    geo_desc: 'The Pyramid is the geometry of focused energy—it collects from a broad base and concentrates toward a single point, creating power through alignment. This is leadership architecture: many contributions focused through a single organizing principle toward a unified aim. The pyramid has represented leadership and civilization-building across cultures, from Egypt to Mesoamerica, because it encodes the principle of organized collective effort. For Leaders, the Pyramid teaches: your role is not to be everything but to be the point through which everything aligns. You focus energy; you do not generate all of it. Meditate on the pyramid to understand your function. Visualize energy flowing up through you toward the apex of your vision, then radiating out from the top to illuminate the direction. Focused, aligned, powerful.',
    gid_in: 'Field Overview',
    gid_in_d: 'You perceive situations at the macro level—seeing the whole field, all the players, the relationships between elements, and the overall state of the system. When you enter any situation, you automatically assess: What is the current condition? What resources are available? Who can do what? What is missing? This bird\'s-eye perception allows you to make decisions that account for the whole rather than just the part in front of you. Your field overview is essential for leadership because leaders must see what individuals cannot see from their positions. The challenge: you may miss details visible only from ground level, or dismiss individual perspectives because you are focused on the whole. Learn to balance macro perception with appreciation for micro data.',
    gid_proc: 'Strategic Alignment',
    gid_proc_d: 'Your mind naturally organizes resources toward objectives—taking available elements and arranging them for maximum effectiveness toward a goal. This is strategic thinking, and it operates continuously in your cognition. When you receive information, you immediately process: How does this affect the objective? How should resources be reallocated? What needs to change? This processing style makes you excellent at execution, at turning plans into outcomes, at ensuring that effort translates into results. The challenge: you may become so focused on the objective that you miss the human experience of those being "organized." Remember that resources include people, and people have needs beyond their functional utility. Include care in your strategy.',
    gid_dec: 'Solar Authority',
    gid_dec_d: 'Your decisions come from the center of your being—the solar plexus, the seat of will, the place where "I want" translates into "it will be." When you decide, you decide with your whole self; there is a felt sense of commitment, of direction chosen, of energy now flowing toward the chosen outcome. This is leadership decision-making: not endless deliberation but clear choice followed by full commitment. Your solar authority is persuasive because people feel your certainty; they align with direction that is clearly chosen. The challenge: your decisions may become disconnected from wisdom if the solar plexus overrides input from heart and mind. Include reflection and compassion in your deciding process, not just will.',
    gid_out: 'Command Frequency',
    gid_out_d: 'You communicate through directives—clear statements of what needs to happen, expressed in a frequency that commands attention and compliance. This is not harshness; it is clarity. When you speak from your leadership function, people understand what is expected and feel motivated to deliver. Your command frequency cuts through ambiguity and creates aligned action. The challenge: command communication is not appropriate for all contexts. Some situations require inquiry, vulnerability, or collaborative dialogue rather than direction. Learn to modulate your communication style for context: command when direction is needed, collaborate when buy-in is needed, listen when understanding is needed. A leader who can only command is a limited leader.',
    rel_align: 'You thrive in relationships with equals—partnerships where both parties are leaders of their own domains, where respect is mutual, and where power dynamics are balanced rather than one-sided. You need partners who are not intimidated by your authority, who have their own strength to bring to the dynamic, and who can challenge you as well as support you. The ideal Leader partner is secure in their own identity (not seeking validation through your status), capable of holding their own in disagreement, and committed to a relationship where both people lead in their areas of strength. Avoid partners who want to be led in everything; that dynamic breeds contempt on both sides.',
    rel_chal: 'Your primary relationship challenge is dominating—treating intimate relationships like organizations to be managed, partners like subordinates to be directed, and love like a project to be optimized. You may struggle to yield, to follow, to receive direction from someone else. Vulnerability may feel like weakness, and you may resist the surrender that intimacy requires. You may attract partners who want to be led, then lose respect for them, creating a destructive cycle. The work: learn that leadership in love looks different from leadership at work. Learn to follow. Learn to yield. Learn that the strength required to surrender is greater than the strength required to command. In intimate relationship, the truest leadership may be the courage to be led.',
    ritual_name: 'The Crown Lift',
    ritual_steps: [
      'Stand with feet hip-width apart, spine straight, shoulders relaxed. This is the posture of sovereign presence—grounded, aligned, open.',
      'Close your eyes and bring your attention to the crown of your head. Visualize a golden cord extending from your crown upward toward the sky, connecting you to something larger than yourself—source, purpose, the highest good you serve.',
      'Gently allow this cord to lift you from above—not pulling but inviting your spine to lengthen, your posture to become more erect, your presence to expand. You are being lifted into your full stature.',
      'As you feel the lift from above, simultaneously feel your feet grounding into the earth. You are connected above and below, channel between heaven and earth, conduit for energy that is larger than you.',
      'Now drop your shoulders. Deliberately release any tension you are holding. Many leaders carry the weight of their responsibilities in their shoulders and neck; release this. The cord from above supports you; you do not need to hold yourself up through tension.',
      'Open your eyes, maintaining this posture: lifted from above, grounded below, shoulders relaxed, spine long. This is sovereign presence—authority that radiates from alignment rather than force.',
      'Throughout your day, when you feel your posture collapsing or your presence shrinking, return to this lift. You do not need to close your eyes or stop what you are doing; simply remember the cord, allow the lift, drop the shoulders. This is how you maintain leadership presence sustainably.'
    ],
    vocation: 'Director / Commander',
    cycle: 'Direction',
    cycle_desc: 'The provision of command and visibility—you are designed to show the way and ensure the group moves together toward it.',
    summary_synthesis: 'You are the pillar that holds the sky—the organizing center around which collective effort coheres, the sun that provides light by which others navigate, the sovereign presence that creates the conditions for many to do their best work. This is not about you being better than others; it is about you serving a function that groups require. Without someone willing to bear the weight of direction, groups wander. Without someone willing to make the call when consensus fails, groups stall. Without someone willing to hold the vision when others waver, groups lose their way. YOU are willing. This is your gift. But remember: the strength you carry is not for yourself alone—it is to create a canopy under which others can thrive. True command is not force but resonance; the best leaders do not push but attract, do not demand but inspire, do not control but enable. The goal is not a group dependent on you but a group empowered by your leadership to function excellently with or without your presence. Lead in such a way that your people outgrow their need for you. That is success.'
  },
  'Artist': {
    contract: 'To translate invisible truths into perceivable beauty—to take what exists only in the realm of the unseen and give it form that others can experience through their senses. You are the bridge between spirit and matter, between the infinite and the finite, between what is felt and what is seen. Art is not decoration or entertainment (though it can include these); it is the rendering visible of what would otherwise remain unknown. Every truth humanity has integrated has first been made accessible through art—story, image, song, dance, poetry—because pure truth is too bright to look at directly. You filter it through beauty so it can be received. Without Artists, truth remains abstract, unreachable, divorced from lived experience. You make the invisible tangible and the transcendent intimate.',
    glitch_name: 'Validation Void',
    glitch_desc: 'Your primary dysfunction is creating for applause rather than truth—making art to fill an internal emptiness through external approval rather than expressing what genuinely wants to emerge. This manifests as chronic need for feedback and praise, shape-shifting your creative voice to match what you think will be appreciated, inability to create without an audience in mind, devastation when your work is criticized or ignored, and loss of authentic creative vision in pursuit of validation. You may find yourself producing work that is technically skilled but emotionally hollow, successful by external measures but unsatisfying internally, or endlessly chasing the next approval hit without ever feeling fulfilled. The deeper pattern: you have confused your worth with your reception, and art has become a desperate attempt to prove you deserve to exist.',
    glitch_fix: 'Create for self first—make art that no one else will ever see, that is created purely for the joy of creation without any thought of audience. Specific practices: Establish a daily creative practice that is entirely private; never show this work to anyone. When creating, practice asking "What wants to emerge?" rather than "What will people like?" Create something ugly, offensive, or unmarketable on purpose—something that could never receive approval. When the urge for validation arises, notice it without acting on it; let the art be enough. Remember: the greatest art emerges when the artist is creating for truth, not for applause. The audience senses authenticity and responds to it. Paradoxically, when you stop creating for others, your work becomes more compelling to others. But this cannot be a strategy; it must be genuine. Create for yourself. The rest follows.',
    oil_name: 'Ylang Ylang',
    oil_desc: 'Ylang Ylang harmonizes the emotional body and unlocks creative and sensual energy—it opens the lower chakras where creative power is generated while connecting to the heart where beauty is perceived. Its rich, floral scent is itself a work of art, complex and multi-layered. For Artists, Ylang Ylang serves as a channel-opener: use it when you feel blocked, when the creative flow has stopped, when you need to reconnect with the pleasure of creation (because creation should feel good, not torturous). Apply it to your lower abdomen (sacral chakra, seat of creativity) and heart before creative work. Diffuse it in your creative space. Let Ylang Ylang remind you that creativity is connected to sensuality, pleasure, and the body—it is not a purely mental process but a full-being flow.',
    crystal_name: 'Carnelian',
    crystal_desc: 'Carnelian ignites creative fire and authentic self-expression—it activates the sacral chakra where creative and sexual energy originate, stimulating the flow of life force into creative manifestation. Its warm orange color resonates with the creative center, and its energy is bold, confident, and unafraid to begin. For Artists, Carnelian serves as an activator and courage-giver: it helps you start when fear of imperfection would keep you frozen, it amplifies creative energy when the flow is weak, and it provides the confidence to share what you create. Wear Carnelian when you work, especially near your lower abdomen. Keep it on your creative altar or workspace. Hold it when you face the blank page or canvas. Carnelian teaches: creativity is fire, and fire does not ask permission to burn.',
    metal_name: 'Mercury',
    metal_desc: 'Mercury (quicksilver) represents the ultimate fluidity of thought and form—it is the only metal that is liquid at room temperature, constantly moving, reshaping, reflecting. This is the Artist consciousness: never fixed, always flowing, taking the shape of whatever container (medium, moment, message) it enters. Mercury is also the metal of the messenger god, connecting realms and transmitting information between them. For Artists, Mercury resonates with your function as translator between the visible and invisible. Your mind should be mercurial—quick, adaptive, flowing between forms without getting stuck in any. Mercury teaches: do not become attached to a single style, medium, or identity. Flow. Let your art be liquid until the moment it crystallizes into form.',
    animal_name: 'Peacock',
    animal_desc: 'The Peacock is your spirit teacher because it embodies radical, unapologetic expression—displaying its magnificent plumage not to seek approval but because display IS its nature. The peacock does not wonder if its feathers are too much; it knows that "too much" is the point. When Peacock appears in your life, it asks: Are you displaying your full creative plumage, or hiding your colors to fit in? Are you creating with full magnificence, or dimming yourself for safety? Peacock also teaches that beauty can be functional—the display serves a purpose in nature. Your art, too, serves purposes beyond decoration: it teaches, heals, awakens, inspires. Do not apologize for your brilliance. The peacock does not apologize for its tail; it simply opens.',
    music_name: 'Jazz / Improvisational',
    music_desc: 'Jazz and improvisational music represent spontaneous creation and fearless experimentation—the willingness to create without knowing exactly where it will go, trusting the flow. This is the essence of authentic artistic expression: not performing a predetermined script but discovering the music in real time. For Artists, jazz serves as both inspiration and training. Listen to it when you need to access spontaneity, when your creative process has become too controlled. Learn from how jazz musicians balance structure and freedom—they know the chord changes AND they improvise within them. Jazz teaches: mastery creates the foundation from which true improvisation becomes possible. And it teaches trust—trust that the flow will go somewhere meaningful, even when you cannot see the destination.',
    color_name: 'Orange',
    color_desc: 'Orange is the color of the sacral chakra—the creative and sexual center, the place where life force becomes creative expression. It is pure creative energy made visible: warm, vibrant, alive with movement and passion. For Artists, orange resonates with the very source of your creative power. Surround yourself with orange in your creative space. Wear it when you need to activate creative energy. Visualize orange light filling your lower abdomen when you feel blocked. Orange teaches: creativity is life force expressed. It is connected to sexuality, pleasure, emotion, and the body. If your creativity has become cerebral, let orange return it to its roots in embodied, pleasurable, alive expression. Create from your whole being, not just your head.',
    freq_name: '639 Hz',
    freq_desc: 'The frequency of harmonic connection—639 Hz works on the heart chakra to create coherence between self and other, which for Artists translates into the connection between creator and audience, between inner vision and outer expression. Art is fundamentally an act of connection: you connect with something true, translate it into form, and through that form connect with those who receive it. 639 Hz supports all these connections. Use it while creating to stay connected to your authentic source. Use it when preparing to share your work to open the channel between you and your audience. 639 Hz teaches: art is not a solo activity but a circuit of connection. Let your work complete the circuit.',
    geo_name: 'Torus',
    geo_desc: 'The Torus is the geometry of self-sustaining flow—energy moves out from the center, curves around, and returns to the center in continuous circulation. This is the shape of the human energy field and of creative flow itself: expression moves outward into form, that form touches audiences and returns (as feedback, as inspiration, as evolution) to the creator, and the cycle continues. For Artists, the Torus represents sustainable creativity: you are not depleting yourself when you create; you are circulating. What you give out comes back transformed. Meditate on the Torus to understand creative flow as circulation rather than expenditure. When you feel depleted by creating, you have broken the circuit somewhere. Restore the flow; let yourself receive as well as give.',
    gid_in: 'Sensory Saturation',
    gid_in_d: 'You perceive the world through heightened senses—drinking in color, texture, sound, sensation with unusual intensity. Where others see a flower, you see seventeen shades of red, the exact curve of each petal, the way light passes through translucent edges. Your sensory channels are wide open, receiving more than most. This sensory saturation is the raw material of your art; you cannot create beauty without first perceiving it in exquisite detail. The challenge: overwhelm. Your wide-open senses can be flooded by intense environments, leaving you exhausted or overstimulated. Learn to modulate your sensory intake, opening fully when you need to perceive and partially closing when you need to rest.',
    gid_proc: 'Alchemical Expression',
    gid_proc_d: 'Your mind processes experience by transmuting it into art—raw sensation, emotion, and perception enter your system and are converted into expression. You do not just experience feelings; you convert them into forms. This is automatic, continuous, and inescapable. Painful experiences become powerful art; joy becomes beauty; even boredom is transmuted into commentary on boredom. This alchemical process is your gift: it means you can make meaning and beauty from anything. The challenge: you may process life through art so consistently that you miss the experience itself. Sometimes the sunset should just be a sunset, not raw material. Learn to sometimes just experience without transmuting.',
    gid_dec: 'Aesthetic Truth',
    gid_dec_d: 'Your decisions are made through beauty—you follow what is aesthetically true, what resonates as beautiful, what feels harmonious. This is not superficiality; beauty is a form of truth, and your aesthetic perception is detecting something real. When a decision is right, it feels beautiful; when wrong, it feels ugly or discordant. Trust this perception; it is your guidance system. The challenge: distinguishing between authentic beauty (which is often simple and subtle) and seductive surfaces (which are often flashy but hollow). Develop discrimination within your aesthetic perception. True beauty has depth; learn to sense the difference between the beautiful and the merely pretty.',
    gid_out: 'Radiant Display',
    gid_out_d: 'You communicate through showing—displaying your inner world through outer expression. Where others might explain, you reveal. Where others might argue, you demonstrate. Your communication IS your art: visual, auditory, kinetic, experiential. People do not just understand what you mean; they experience it. This makes your communication powerful and memorable. The challenge: some contexts require explanation, not display. Learn when to show and when to tell, when to create and when to simply speak. Let your radiant display be one mode among several, not your only option.',
    rel_align: 'You thrive in relationships that function as mirrors—partnerships where you are truly seen, where your creative expression is witnessed and reflected back with appreciation and understanding. You need partners who can perceive what you are expressing (they do not have to be artists, but they need aesthetic sensitivity), who appreciate beauty in life, and who can receive your creative offerings as the gifts they are. The ideal Artist partner is a genuine audience—not critical or dismissive, not falsely praising, but authentically receptive to what you create and who you are.',
    rel_chal: 'Your primary relationship challenge is performing love—treating intimate relationship as another stage, another audience, another place to display rather than to truly connect. You may hide behind your art, expressing through creative gifts what you struggle to say directly. You may shape-shift to be what your partner seems to want, performing love rather than feeling it. You may choose partners who offer applause rather than intimacy, because applause is more familiar. The work: learn that intimacy is not performance. Learn to let yourself be seen without the filter of creative expression. Learn to connect before, beneath, and beyond your art. You are more than what you create.',
    ritual_name: 'The Canvas Clear',
    ritual_steps: [
      'Take a blank piece of paper or any disposable creative medium—something you can destroy without loss. This ritual requires something to sacrifice.',
      'Set a timer for three minutes. When it starts, express whatever is inside you onto this surface WITHOUT any intention of making it "good" or showing it to anyone. Scrawl, scribble, write, draw—whatever emerges. Do not filter or compose. This is not art; this is release.',
      'Let yourself express what you would never show—ugly feelings, petty thoughts, shameful desires, raw pain. This page is a container for everything you hide from your audience. Fill it.',
      'When the timer ends, stop. Look at what you have made. This is your uncurated interior. Witness it without judgment.',
      'Now destroy the page. Tear it, burn it (safely), dissolve it in water. What you have expressed is released; it does not need to be kept. The purpose was the expression, not the artifact.',
      'This ritual serves to clear the creative channel of blockages—emotions, thoughts, and energies that clog the flow because they have no acceptable outlet. By giving them an outlet that will be destroyed, you release them without consequence. The audience never sees; you remain safe. But you are cleared, and the creative channel is open.',
      'Use this ritual regularly, especially when you feel blocked or when you have been creating heavily for external approval. It resets your creative process to authentic expression.'
    ],
    vocation: 'Creator / Performer',
    cycle: 'Expression',
    cycle_desc: 'The outward projection of inner truth—you are designed to take what exists inside and manifest it where others can experience it.',
    summary_synthesis: 'You are the prism through which the light of the universe passes and fractures into a million colors. This is not metaphor but accurate description: pure truth is too intense to perceive directly, and you translate it into frequencies that human eyes can see, human ears can hear, human hearts can feel. Your only duty is to keep the glass clean—to clear the distortions that interfere with true transmission. What the world does with the light is not your concern; your concern is the clarity of the translation. But here is the trap: seeking approval muddies the glass. When you create for applause, you are no longer transmitting truth but manufacturing what you think others want—and that is not art but manipulation, not expression but performance. The most powerful creative work emerges from artists who are creating for the sake of creation, expressing because expression is their nature, translating truth because that is what they ARE. You do not need applause to be an Artist; you are an Artist because that is your fundamental nature. Express. The rest follows—or it does not, and you are still an Artist.'
  },
  'Alchemist': {
    contract: 'To transmute heavy density into higher coherence—to take what is base, stuck, poisonous, or unconscious and transform it into something refined, flowing, healing, and awakened. You are the crucible in which transformation occurs, the heat that catalyzes change, the process by which lead becomes gold. This is not metaphor for you; it is literal function. Every situation you enter, every relationship you form, every system you touch becomes a site of transformation. You cannot help but catalyze change in what you contact because transformation is your frequency, and proximity to you initiates process. The alchemical work that medieval practitioners sought to perform on metals, you perform on consciousness—yours and others\'. You are the living laboratory of transmutation.',
    glitch_name: 'Process Addiction',
    glitch_desc: 'Your primary dysfunction is getting addicted to the process of transformation without ever completing it—perpetually cooking without producing gold, constantly processing without resolution. This manifests as chronic unfinished projects (always mid-transformation, never complete), attraction to crisis and drama (because these provide more material to transform), inability to rest in completion (because completion feels like death to the process-addicted self), endless self-improvement without ever being "improved enough," and exhaustion from constant processing. You may find yourself surrounded by half-finished transformations, addicted to the intensity of the work while never enjoying its fruits, unable to simply BE because you are always BECOMING. The deeper pattern: you fear that if the transformation completes, you will no longer be needed—or worse, you will have to face what remains when the work is done.',
    glitch_fix: 'Finalize. Complete the work. The transformation must end for the gold to be usable. Specific practices: Set hard deadlines for processes and honor them regardless of whether you feel "done." Practice declaring things complete even when you can imagine further refinement. Create a ritual of completion that marks endings definitively. After completing a transformation, rest before starting another—do not immediately find new material to process. Ask yourself: "Am I processing this because it needs processing, or because I need to be processing?" Notice the addiction and interrupt it. Remember: gold that is never removed from the crucible is not gold—it is just perpetually heated metal. The point of transformation is to produce something USABLE, not to process forever.',
    oil_name: 'Myrrh',
    oil_desc: 'Myrrh facilitates deep transformation—it has been used in burial and spiritual rituals across cultures because it supports the transition between states. For Alchemists, Myrrh resonates with your function: it helps things die so they can be reborn, supports the release of what no longer serves, and creates an energetic container for transformation to occur. Use Myrrh during transformational processes—when you are working on yourself or facilitating change for others. Apply it when you need to let something go, when you are in the chrysalis phase of change, or when you need support to complete a transformation rather than perpetuate it. Myrrh teaches: transformation includes death. Something must end for something new to begin. Do not try to transform without releasing.',
    crystal_name: 'Amethyst',
    crystal_desc: 'Amethyst transmutes lower frequencies into spiritual clarity—it is the stone of transformation, taking what is base and refining it into what is elevated. Its purple color represents the marriage of matter (red) and spirit (blue), which is exactly your function. Amethyst supports the Alchemist by providing a stable, high-frequency anchor during the volatility of transformation. When the process becomes too intense, Amethyst reminds you that the goal is clarity, not chaos. Wear Amethyst during transformational work. Keep it in spaces where you process. Sleep with it to support the transformational work that continues in dreams. Amethyst teaches: transformation is not destruction but refinement. You are not trying to eliminate the lower but to raise its frequency.',
    metal_name: 'Platinum',
    metal_desc: 'Platinum is the highest-frequency metal—rarer than gold, more stable, resistant to corrosion, and capable of catalyzing reactions without itself being consumed. This is mature Alchemist function: you facilitate transformation in others without being destroyed by it; you catalyze change while maintaining your own integrity. Platinum is also used as a catalyst in chemical reactions, speeding processes without being changed by them. For Alchemists, Platinum represents the evolved form of your function. Work with Platinum symbolically: appreciate its qualities, let it teach you how to catalyze without consuming yourself. The goal is not to burn in your own fire but to tend fires that transform others while you remain intact.',
    animal_name: 'Snake',
    animal_desc: 'The Snake is your spirit teacher because it embodies transformation more visibly than any other creature—literally shedding its skin to reveal the new form beneath, dying to the old self to live as the new. When Snake appears in your life, it asks: What skin are you ready to shed? What form has become too tight for who you are becoming? Are you allowing the uncomfortable process of shedding, or clinging to the old skin because it is familiar? Snake also teaches that transformation is cyclical, not once-and-done. You will shed many skins in your life. Each shedding is complete in itself AND part of a larger process of continuous becoming. Snake medicine is not comfortable—shedding is vulnerable, awkward, and temporarily blinding. But it is necessary. Let yourself shed.',
    music_name: 'Experimental / Drone',
    music_desc: 'Experimental and drone music represents deep frequency work that dissolves fixed patterns into pure potential. These are not songs but soundscapes, not melodies but frequencies, not entertainment but transformation chambers. For Alchemists, this music serves as a tool: it creates the sonic container in which transformation can occur. Use drone music during processing sessions, during meditation, during any time you are consciously transforming something. Let the frequencies do their work on your energy system. Notice how these sounds dissolve what is rigid and create space for new forms. This music teaches: transformation happens at the frequency level before it manifests at the physical level. Work on the subtle and the dense will follow.',
    color_name: 'Purple',
    color_desc: 'Purple is the transformation frequency—the marriage of matter (red) and spirit (blue) into something that is neither and both. It is the color of royalty precisely because it represents the ultimate achievement of alchemical work: the elevation of the base into the noble. For Alchemists, purple resonates with your core function. Surround yourself with purple during transformational work. Wear it when you are in active processing. Visualize purple light filling the crucible of whatever transformation you are facilitating. Purple teaches: transformation is not the destruction of the lower but its elevation into the higher. Matter and spirit are not enemies; they are partners in the great work. Your function is to marry them.',
    freq_name: '432 Hz',
    freq_desc: 'The frequency of universal math—432 Hz is said to be aligned with the natural harmonic frequency of the universe, with sacred mathematics, with the geometry of existence itself. For Alchemists, this frequency represents the template toward which transformation aims: universal coherence, alignment with the fundamental structure of reality. Use 432 Hz as a calibration frequency—play it to tune your system to universal harmony, to remind yourself what "gold" actually is. The alchemical gold is not just any refinement but alignment with the cosmic pattern. 432 Hz teaches: the goal of transformation is not arbitrary; there is a pattern, a template, a frequency of coherence that you are moving toward. This frequency is it.',
    geo_name: 'Merkaba',
    geo_desc: 'The Merkaba is the geometry of counter-rotating fields—two interlocked tetrahedra spinning in opposite directions, creating a field of transformation through the dynamic tension of their movement. This is the geometric signature of alchemical work: transformation happens in the space between opposing forces, in the dynamic tension of polarities held together. For Alchemists, the Merkaba represents the mechanism of your function. You hold opposites in creative tension until something new emerges. Meditate on the Merkaba to understand how transformation works: not by eliminating one pole but by spinning both until their interaction generates something neither could produce alone. The friction of counter-rotation generates heat; heat is what transforms.',
    gid_in: 'Frequency Reading',
    gid_in_d: 'You perceive the world through frequency—sensing the vibrational state of people, places, situations, and systems. Where others see objects or behaviors, you perceive density and coherence, stagnation and flow, what is stuck and what is moving. This frequency reading allows you to immediately identify where transformation is needed, what is ready to shift, and what is resisting change. Your perception is diagnostic: you see not just what IS but what it WANTS to become, and what is preventing that becoming. The challenge: you may perceive frequency so constantly that you cannot turn it off, cannot simply experience without analyzing the vibrational state. Learn to modulate your reading—sometimes you need to perceive, sometimes you need to just experience.',
    gid_proc: 'Transmutation',
    gid_proc_d: 'Your mind naturally converts lead to gold—takes dense, stuck, low-frequency input and processes it into refined, flowing, high-frequency output. This is automatic. Pain enters and is converted to wisdom. Conflict enters and is converted to growth. Limitation enters and is converted to expansion. You are a processing plant for transformation, and everything that enters you is altered. This makes you valuable to anyone who wants to change; proximity to you accelerates their transformation. The challenge: you may become so identified with processing that you cannot stop, cannot simply receive without converting, cannot let anything remain as it is. Sometimes things do not need to be transformed; they need to be accepted.',
    gid_dec: 'Integrative Flow',
    gid_dec_d: 'Your decisions wait for the shift—you do not force conclusions but allow them to emerge from the alchemical process. When a decision is cooking, you know; you can feel the components interacting, the pressure building, the transformation progressing. The decision emerges when the process completes, not before. This decision-making style produces choices that are fully integrated, that have been tested in the fire, that will hold. The challenge: waiting for the shift can become endless waiting, process addiction disguised as discernment. Learn to distinguish between genuine cooking time and avoidance of finalization. Set time limits. Trust that the process has progressed enough. Decide before you feel completely ready; you rarely will.',
    gid_out: 'Catalytic Speech',
    gid_out_d: 'You communicate through words that change state—your language initiates transformation in those who receive it. This is not persuasion but catalysis: you do not convince people to change, you create the conditions in which change becomes possible, then becomes inevitable. Your words carry frequency; they work on levels beyond meaning. The challenge: catalytic speech is powerful and not always welcome. Some people do not want to be transformed, and your words may destabilize systems that prefer to remain stuck. Learn to modulate your catalytic effect, to turn it up or down depending on context. Not every conversation needs to be transformational; sometimes people just need information.',
    rel_align: 'You thrive in relationships that are explicitly transformational—partnerships where both parties are actively growing, where change is welcomed rather than feared, and where the relationship serves as a crucible for mutual evolution. You need partners who can handle intensity (because your frequency is intense), who are committed to their own growth (not just receiving transformation from you), and who understand that loving you means being willing to change. The ideal Alchemist partner is themselves in active process, capable of witnessing your transformations without trying to stop them, and able to receive your catalytic effect without being destabilized.',
    rel_chal: 'Your primary relationship challenge is constant processing—treating the relationship as an endless transformation project rather than something that can also simply BE. You may be unable to let good be good, constantly identifying more lead to convert, more density to refine, more work to do. Partners may feel they are never enough as they are, that you are always seeing their potential rather than appreciating their present. The work: learn that some things do not need transformation—they need appreciation. Practice seeing your partner as already gold, at least some of the time. Rest in what is rather than always reaching for what could be. Transformation has seasons; let there also be seasons of simple enjoyment.',
    ritual_name: 'The Fire Bath',
    ritual_steps: [
      'Create a safe fire space: a candle flame is sufficient, but a larger fire is more powerful if available. Fire is the element of transformation, and you will use it to purify what needs releasing.',
      'Sit comfortably before the flame, close enough to feel its warmth. Take several deep breaths, arriving fully in the present moment. Let your eyes soft-focus on the fire.',
      'Identify what you are ready to transform—a belief, a pattern, an emotion, an attachment. Be specific. Name it clearly, either aloud or internally. You must know what you are putting in the crucible.',
      'Visualize this pattern as a dense object—a rock, a piece of metal, a dark mass. See it in your mind\'s eye or feel it in your body. This is the lead you will be converting.',
      'Now breathe the heat of the fire into this dense object. Feel the fire entering the pattern, heating it, beginning to melt its rigid structure. This may be uncomfortable; transformation often is. Stay with it.',
      'Continue breathing fire into the pattern until you feel a shift—a melting, a lightening, a release. This is the transmutation occurring. The lead is becoming gold. You are not destroying the pattern; you are raising its frequency.',
      'When the transformation feels complete, visualize the refined energy—lighter, brighter, more coherent—reintegrating into your system. This is the gold. Receive it.',
      'Thank the fire. Sit quietly until you feel stable. The transformation will continue integrating over time; this ritual initiated the process.',
      'Use this ritual when you identify specific patterns ready for transformation. Do not use it constantly—transformation needs integration time. Let the gold cool before reaching for more lead.'
    ],
    vocation: 'Transformer / Chemist',
    cycle: 'Transmutation',
    cycle_desc: 'The deep chemical shift from one state to another—you are designed to facilitate the transformation of lead into gold, density into coherence.',
    summary_synthesis: 'You are the crucible—the container in which the raw material of life is subjected to heat and pressure until it transforms into something precious. This is not comfortable work; the crucible gets hot. The material resists change. The process takes as long as it takes. But YOU are designed for this. Your intensity is not a curse but the heat required for the reaction. Your attraction to difficult situations is not masochism but the recognition that difficult situations contain lead that can become gold. Life throws you density because you are capable of transforming it. However—and this is crucial—the transformation must COMPLETE. Gold left in the crucible forever is not gold; it is just perpetually heated metal. You must finalize, remove the gold, and LET THE CRUCIBLE COOL before filling it with more lead. Your process addiction is the great trap: you mistake the intensity of processing for productivity, the heat of the fire for its product. Learn to finish. Learn to rest. Learn to appreciate the gold you have already made before reaching for more lead. Then, from a place of completion rather than addiction, you can return to the transformational work that is your gift to offer the world.'
  },
  'Guardian': {
    contract: 'To anchor the core frequency and protect the lineage—to be the living wall that shields what is sacred, the keeper of wisdom that must be transmitted across generations, the sentinel that never sleeps while that which is precious sleeps safely. You are not here to create the new or transform the old; you are here to PRESERVE what must endure. Every culture, family, organization, and tradition requires Guardians: those who remember what must not be forgotten, who protect what must not be lost, who maintain the integrity of the container so its contents remain safe. Without Guardians, wisdom evaporates, traditions dissolve, and each generation starts from zero. You are the continuity that makes progress possible, the stability that makes evolution safe, the protector that makes creativity feasible.',
    glitch_name: 'Stagnation Shield',
    glitch_desc: 'Your primary dysfunction is protecting what is dead—shielding structures, beliefs, traditions, and patterns that have outlived their usefulness and now strangle the life they once served. This manifests as reflexive defense of tradition even when that tradition is harmful, inability to distinguish between preserving what is essential and preserving what is merely familiar, resistance to all change as if all change were threat, and creating fortresses so impenetrable that nothing can get in OR out. You may find yourself defending institutions you do not even believe in, attacking innovators as threats rather than recognizing them as partners in life\'s evolution, suffocating the growth of those you are trying to protect, or becoming a tomb rather than a sanctuary. The deeper pattern: you have confused your function (protecting what is alive and valuable) with a rigid identity (resisting all change of any kind).',
    glitch_fix: 'Open the gates deliberately and regularly to let life flow through your protected spaces. Specific practices: Regularly review what you are protecting and ask: "Is this still alive? Is this still serving life?" Be willing to let go of structures that have outlived their purpose, even when this feels like betrayal. Create doors in your walls, not just more walls. Trust that what is genuinely valuable will survive exposure to the new; if it cannot survive, perhaps it should not. Practice saying yes to change while still maintaining essential boundaries. Remember: a fortress with no door is a tomb. Your function is not to stop all flow but to regulate flow—deciding what enters and exits while keeping the core safe. Dead things do not need protection; they need release.',
    oil_name: 'Sandalwood',
    oil_desc: 'Sandalwood protects the aura while inviting peace—it creates sacred space that is boundaried without being aggressive, safe without being stifling. This is the Guardian ideal: protection that is firm and calm rather than fearful and reactive. For Guardians, Sandalwood serves as a signature frequency: it reminds your system what healthy protection feels like. Use it to consecrate spaces you are protecting, to anoint yourself when you need to strengthen your shielding capacity, or to create calm when your protective instincts have become hyperactivated. Sandalwood teaches: protection does not require aggression. The deepest safety is peaceful. A sanctuary is not a battlefield; it is a haven.',
    crystal_name: 'Obsidian',
    crystal_desc: 'Obsidian is volcanic glass—fire that has cooled into solid form, still containing the memory of intensity but now stable and protective. It shields the energy field against negative influences while maintaining grounded presence. For Guardians, Obsidian resonates with your function: you take raw protective instinct (fire) and solidify it into stable boundaries (glass). Obsidian also reveals truth—it shows you what is actually threatening versus what your fears project as threatening. This is essential medicine for Guardians prone to seeing danger everywhere. Carry Obsidian when you need extra protection. Place it at boundaries (doorways, property lines, desk edges) to anchor your protective field. Use it in meditation to clarify what genuinely needs protecting versus what you are over-defending.',
    metal_name: 'Titanium',
    metal_desc: 'Titanium is the ultimate protective metal—incredibly strong, remarkably lightweight, resistant to corrosion and extreme conditions. It protects without burdening. For Guardians, Titanium represents the evolved form of your function: protection that is effective without being heavy, boundaries that are strong without being rigid, defense that does not exhaust the defender. Work with Titanium symbolically: appreciate its qualities, let it teach you that strength does not require weight. The heaviest armor is not the strongest; the best protection is that which can be sustained indefinitely because it does not drain the protector. Let your guardianship be Titanium—powerful, light, enduring.',
    animal_name: 'Elephant',
    animal_desc: 'The Elephant is your spirit teacher because it embodies protective wisdom passed across generations—Elephants remember, they protect their young fiercely, they maintain family structures across decades, and they mourn their dead. When Elephant appears in your life, it asks: What ancestral wisdom are you carrying? What have you been entrusted to protect across time? Are you using your strength wisely—protecting the vulnerable while also knowing when to let go? Elephants are also known for removing obstacles, suggesting that protection sometimes means clearing the path rather than building walls. Elephant medicine is not just about defense but about wise stewardship of what has been entrusted to you. Guard it faithfully, and pass it on.',
    music_name: 'Tribal / Drumming',
    music_desc: 'Tribal and drumming music carries primal rhythms that anchor and protect the sacred container. These are the sounds that have guarded ceremonial spaces across all human cultures, creating sonic walls that define sacred from profane, safe from unsafe, inside from outside. For Guardians, this music serves as activation and reminder. Use drumming to consecrate spaces, to anchor your protective function, to connect with the ancestral lineage of protectors you belong to. Let the rhythm ground you; let it remind you that guardianship is ancient and honored, that you are part of a long line of those who have held the gates. The drum creates the boundary; within it, the ceremony can unfold.',
    color_name: 'Black',
    color_desc: 'Black is full absorption—it takes in all light, all frequency, all energy, containing it within itself. It is the void that protects and contains all potential, the darkness in which new things gestate, the night that allows rest and regeneration. For Guardians, black resonates with your absorptive function: you take in what would harm those you protect, you create containers that hold what must be held, you provide the darkness in which the vulnerable can safely grow. Use black deliberately: wear it when you need extra protection, surround spaces with it when they need containing, visualize it when you are creating boundaries. Black teaches: protection is not about deflection but about absorption. You can contain what would harm others, neutralizing it within your greater capacity.',
    freq_name: '174 Hz',
    freq_desc: 'The frequency of pain relief and security—174 Hz works on the most foundational level, creating a sense of safety that allows everything else to relax. For Guardians, this frequency represents what you provide: the baseline safety that makes everything else possible. When the organism (person, family, organization) feels fundamentally secure, it can grow, explore, create, risk. Without that foundational security, all energy goes to survival. Use 174 Hz to anchor protective spaces, to calm hypervigilant systems (including your own), to create the frequency of safety that allows those you protect to flourish. 174 Hz teaches: your function is not just about stopping threats but about creating the felt sense of security that is the foundation of all thriving.',
    geo_name: 'Sphere',
    geo_desc: 'The Sphere is the geometry of wholeness and perfect protection—every point on its surface is equidistant from the center, creating a boundary that is equally strong in all directions with no weak points. It is the shape of eggs, cells, planets—containers that protect what develops within. For Guardians, the Sphere represents the ideal protective boundary: complete, consistent, without gaps or vulnerabilities. Meditate on the Sphere when you need to strengthen your protective field. Visualize a sphere of light completely surrounding what you are protecting. The Sphere teaches: true protection is comprehensive. Partial protection is vulnerability disguised. But also notice: spheres have no doors. At some point, what you protect must emerge. Build temporary spheres, not permanent ones.',
    gid_in: 'Threat Detection',
    gid_in_d: 'You perceive the world through a security lens—automatically scanning for breaches, vulnerabilities, dangers, and potential threats. When you enter any space, your first assessment is: Is this safe? Where are the exit points? What could go wrong? Who does not belong here? This threat detection operates constantly, even when you are not consciously aware of it. Your perceptual system is tuned to danger frequency, catching signals that others miss. This makes you invaluable as a protector; you see the threat before it manifests. The challenge: chronic threat detection is exhausting and can become paranoia. Learn to distinguish between genuine threats and phantom projections of your fear. Not everything is dangerous; not everyone is an enemy.',
    gid_proc: 'Preservation Logic',
    gid_proc_d: 'Your mind processes information through a preservation framework—automatically assessing how inputs affect the safety and continuity of what you are protecting. Every new piece of information is filtered through: Does this threaten what I guard? Does this support what I guard? How do I respond to maintain integrity? This processing style makes you excellent at risk management, at identifying vulnerabilities, at creating systems that endure. The challenge: preservation logic can become conservative to the point of stagnation. Sometimes change serves what you protect, and your processing may have difficulty recognizing when protection means allowing transformation rather than preventing it.',
    gid_dec: 'Protective Instinct',
    gid_dec_d: 'Your decisions are made through protective instinct—a visceral sense of what will keep safe what you guard. This is not calculated risk assessment but felt knowing, the body\'s wisdom about danger and safety. When a threat is real, you feel it in your nervous system before your mind can articulate why. Trust this instinct; it has been refined across millions of years of evolution. The challenge: instinct can be triggered by false alarms, especially if you have experienced trauma. Learn to distinguish between accurate threat response and triggered reaction. Your instinct is valuable but not infallible; verify before acting.',
    gid_out: 'Boundary Setting',
    gid_out_d: 'You communicate through clear boundaries—decisive declarations of what is allowed and what is not, who enters and who does not, what behavior is acceptable and what crosses the line. Your "no" is clear and firm; there is no ambiguity in your boundary-setting. This makes you effective at protecting what you guard; threats know where the line is. The challenge: you may over-rely on "no," creating more boundaries than are necessary, shutting out what should be welcomed along with what should be blocked. Learn to balance your clear "no" with a clear "yes." Protection includes welcoming what supports life, not just blocking what threatens it.',
    rel_align: 'You thrive in relationships built on trust—partnerships where reliability is foundational, where both parties can count on each other absolutely, where safety is not negotiable. You need partners who keep their word, who show up consistently, who do not create unnecessary drama or instability, and who respect the boundaries you set. The ideal Guardian partner is themselves trustworthy (so you can relax your vigilance within the relationship), appreciates your protective nature (rather than chafing against it), and provides you with the rare experience of feeling protected yourself (because you are always protecting others).',
    rel_chal: 'Your primary relationship challenge is building walls that keep intimacy out—treating your partner as a potential threat rather than an ally, protecting yourself so thoroughly that no one can reach you, and confusing vulnerability with weakness. You may test partners repeatedly to verify their trustworthiness, never quite letting them pass. You may withdraw behind your boundaries the moment you feel threatened, which in intimacy is often. You may be so focused on protecting others that you never let yourself be protected, creating one-way relationships that exhaust you. The work: learn that intimacy requires letting someone inside your walls. Learn that vulnerability is not weakness but courage. Let yourself be protected sometimes. Not everyone is a threat; some are sanctuary.',
    ritual_name: 'The Perimeter Walk',
    ritual_steps: [
      'Identify the space you are protecting—your home, your room, your workspace, your family, your own body. You will be walking its perimeter, whether physically or visualized.',
      'Begin at any point on the perimeter and start walking slowly, mindfully, with attention on the boundary itself. If the boundary is physical (walls, fences), touch it as you walk. If metaphorical, visualize it clearly.',
      'As you walk, notice any weak points, any places where the boundary feels thin or vulnerable. Do not judge; simply observe. You are auditing your protection.',
      'At each corner or significant point, stop and make a declaration of protection. Speak aloud: "This boundary is strong. This space is safe. What is mine is protected." Let the words carry intention.',
      'Continue until you have completed the full circuit. You should arrive back where you started, having traced the entire perimeter.',
      'Stand at the entrance point—the door, the gate, the threshold. This is where you decide what enters. Place your hand on it (physically or visualized) and declare: "I guard this gate. I decide what enters. I protect what is within."',
      'Now deliberately open the gate (physically or in visualization) and say: "I open to what serves. I welcome what supports life. The gate is not sealed—it is guarded."',
      'Close the gate and complete the ritual. Your boundaries have been walked, acknowledged, and consciously claimed. Use this ritual regularly—weekly, or whenever your protected space feels compromised.'
    ],
    vocation: 'Protector / Steward',
    cycle: 'Preservation',
    cycle_desc: 'The holding of space and maintaining of integrity—you are designed to ensure that what is valuable endures, that what is sacred remains safe.',
    summary_synthesis: 'You are the keeper of the gate—the one who stands between what is sacred and what would profane it, between what is vulnerable and what would harm it, between what must endure and what would destroy it. This is ancient work, honored work, essential work. Every sanctuary requires a Guardian; every treasure requires a keeper; every lineage requires one who remembers and protects the transmission. This is you. But hear this warning: a fortress with no door is a tomb. Your walls are not meant to stop all flow but to regulate it—to decide what enters and what does not, to open for what supports life and close for what threatens it. When you find yourself defending what is already dead, maintaining structures that have become prisons, protecting patterns that no longer serve, you have confused your function with rigidity. The true Guardian knows that what is genuinely alive can survive exposure to the new. The true Guardian protects life, not just form—and sometimes protecting life means allowing the form to change. Guard with wisdom, not just strength. Protect what is alive, and let go of what has died. Keep the gate, but remember: gates are meant to open as well as close.'
  },
  'Seeker': {
    contract: 'To find the unifying thread in the chaos—to follow the trail of meaning through the wilderness of existence until you discover what connects all things. You are not here to accept easy answers, inherited beliefs, or convenient truths; you are here to SEEK for yourself, to ask the questions that most people are afraid to ask, and to follow those questions wherever they lead. The Seeker function is the engine of all wisdom: without those willing to question, to search, to refuse satisfaction with the superficial, humanity would remain forever at the surface of truth. Your endless curiosity, your inability to rest in false certainty, your compulsion to go deeper—these are not restlessness but sacred function. You are the question the universe asks itself.',
    glitch_name: 'Eternal Wander',
    glitch_desc: 'Your primary dysfunction is seeking everywhere except where the treasure lies—running from teaching to teaching, tradition to tradition, experience to experience without ever stopping long enough to find what you are actually seeking. This manifests as spiritual materialism (collecting practices rather than practicing them), chronic dissatisfaction (nowhere is the right place, no teaching is complete, no path is deep enough), inability to commit to a single path long enough to receive its fruit, romanticizing what is distant while devaluing what is present, and exhaustion from endless movement without arrival. You may find yourself with encyclopedic knowledge of many paths and mastery of none, surrounded by the starting materials for wisdom without the wisdom itself, convinced that the answer is always somewhere else. The deeper pattern: you have become addicted to the search itself, using seeking as a way to avoid the terror of finding—because if you find, the search ends, and you do not know who you are without your questions.',
    glitch_fix: 'Find center—discover that what you seek is not elsewhere but here, not in the future but now, not in the external but in the one who seeks. Specific practices: Choose ONE path and commit to it for a defined period (months, years) regardless of the attraction of alternatives. When the urge to change paths arises, recognize it as the addiction and stay. Practice deep investigation of what is present rather than broad survey of what is elsewhere. Ask the ultimate Seeker question: "Who is it that seeks?" Follow this question inward rather than outward. Sit still—not seeking anything—and notice what remains when seeking stops. The treasure is under your own feet; you have been walking over it your whole life. Stop seeking and find.',
    oil_name: 'Lotus',
    oil_desc: 'Lotus represents the emergence of light from the mud—the journey from dark, uncertain beginnings through murky waters to the light of the open surface. This is the Seeker path made botanical: starting in confusion, moving through uncertainty, finally blooming into wisdom. For Seekers, Lotus serves as both reminder and medicine. Use it when you feel lost in the muddy water of your seeking, when you cannot see where the path leads, when you need faith that the journey through confusion leads to clarity. Lotus teaches: the mud is not an obstacle to the bloom; it is the source of the bloom\'s nourishment. Your confusion, your questions, your not-knowing—these are not failures but the fertile ground from which wisdom grows. Trust the process. Keep moving toward the light.',
    crystal_name: 'Selenite',
    crystal_desc: 'Selenite connects to higher guidance and illuminates the path through uncertainty—it is the crystallized light that helps you see when the way is dark. Named for Selene, the Moon goddess, it carries lunar energy: reflective, intuitive, guiding through darkness rather than eliminating it. For Seekers, Selenite serves as a pathfinder. Use it when you do not know which way to go, when the search has become disorienting, when you need to connect with guidance beyond your own understanding. Place Selenite in your seeking space. Hold it during meditation. Sleep with it near your head to receive guidance in dreams. Selenite teaches: you do not have to see the whole path to take the next step. Trust the light that illuminates just enough.',
    metal_name: 'Tin',
    metal_desc: 'Tin is the metal of Jupiter—the planet of expansion, wisdom, growth, and the larger perspective. It represents the ever-widening circles of your seeking, the expansive quality of your questions, the growth that comes from genuine inquiry. Tin is also protective and flexible, suggesting that seeking wisdom includes both protection (of your discernment) and flexibility (of your assumptions). For Seekers, Tin represents the expansive nature of your function. Work with Tin symbolically: appreciate how it blends with other metals (as your seeking integrates diverse wisdoms), how it protects (as your discernment protects against false teachings), how it expands (as your understanding grows through seeking). Let Tin teach you that expansion is your nature, but expansion must eventually stabilize into form.',
    animal_name: 'Deer',
    animal_desc: 'The Deer is your spirit teacher because it embodies gentle sensitivity to subtle fields—the capacity to perceive what is barely visible, to sense what is approaching before it arrives, to move through the forest of uncertainty with grace. Deer are alert without being aggressive, aware without being fearful, sensitive without being fragile. When Deer appears in your life, it asks: Are you paying attention to the subtle signals? Are you moving with gentleness and grace, or crashing through the forest of your seeking? Are you trusting your sensitivity to guide you? Deer also teaches presence—Deer are supremely present, sensing the NOW rather than lost in the past or future. For Seekers who are always looking toward the next horizon, Deer medicine brings you back to the only place where truth can be found: here, now, this.',
    music_name: 'New Age / Meditative',
    music_desc: 'New Age and meditative music creates contemplative soundscapes for inner journeying and seeking. These are not songs but atmospheres, not performances but invitations to go deeper. For Seekers, this music serves as a container for your inquiry: it creates the sonic space in which questions can be asked and answers can emerge. Use meditative music during contemplation, during journaling, during any practice of inner exploration. Let it slow your pace, deepen your attention, and create space for the subtle to become audible. This music teaches: what you seek may be too quiet to hear amid noise. Create silence, create space, create conditions for the whisper of truth to reach you.',
    color_name: 'Silver',
    color_desc: 'Silver is lunar reflection—the light that reveals hidden truths, not by generating brightness but by reflecting what is already there. Silver sees in the dark, illuminates without consuming, reveals without exposing. For Seekers, silver resonates with your function: you are not creating truth but discovering it, not generating light but finding where light already shines. Use silver to enhance your seeking capacity. Wear it when you need heightened perception. Surround yourself with silver during contemplative practices. Visualize silver light illuminating what is hidden when you seek understanding. Silver teaches: the truth you seek is already present; you are learning to perceive it. Your seeking is not creating but unveiling.',
    freq_name: '285 Hz',
    freq_desc: 'The frequency of healing repair—285 Hz works on the energetic body to heal wounds and restore integrity. For Seekers, this frequency addresses a specific wound: the wound of not-knowing, the pain of existential uncertainty, the exhaustion of endless searching. Your seeking often begins with a wound—a question that hurts, a confusion that causes suffering, a gap between the truth you need and the truth you have. 285 Hz helps heal these seeking wounds, not by providing answers but by restoring the integrity of the seeker. Use this frequency when your seeking has become painful, when the questions are wearing you down, when you need to remember that the seeker is not broken simply for not yet having found.',
    geo_name: 'Spiral',
    geo_desc: 'The Spiral is the geometry of evolution—the path that seems to circle back but actually moves forward (or inward) with each revolution. It is the form of galaxies, shells, DNA, the unfolding of life itself. For Seekers, the Spiral is your geometric signature: you do not progress in straight lines but in spirals, revisiting the same territories at higher levels, asking the same questions with deeper understanding. What seems like repetition is actually evolution. Meditate on the Spiral to understand your seeking pattern: you ARE progressing, even when it feels like you are covering the same ground. Each revolution brings you closer to center. The Spiral teaches: the path to the center winds outward first. Trust the spiral; it knows the way.',
    gid_in: 'Pattern Tracking',
    gid_in_d: 'You perceive the world by tracking patterns—following synchronicities, noticing connections, seeing the threads that link apparently separate events. When something catches your attention, you follow it to see where it leads. You are always asking: "What does this mean? What is this connected to? What is the universe trying to tell me?" This pattern tracking is the perceptual engine of your seeking; it leads you from clue to clue, teaching to teaching, insight to insight. The challenge: not every pattern is meaningful. Sometimes coincidence is just coincidence, and your pattern-seeking can create connections that are not actually there. Learn to verify your patterns, to hold them lightly until confirmed.',
    gid_proc: 'Spiral Logic',
    gid_proc_d: 'Your mind processes information by circling toward truth—not approaching directly but spiraling inward, each pass revealing more, each revolution going deeper. This is not inefficiency; it is thoroughness. You see things from multiple angles before synthesizing, you revisit questions repeatedly rather than answering once and moving on. Spiral logic produces deep understanding because it has approached truth from every direction. The challenge: you may spiral endlessly without ever arriving at center, using the spiral as avoidance of conclusion. At some point, you have circled enough. Drop into the center. Let the spiraling become stillness.',
    gid_dec: 'Resonant Pull',
    gid_dec_d: 'Your decisions are made by following the pull of mystery—moving toward what attracts your seeking energy, choosing the path that promises depth and discovery. When something resonates with your seeker function, you feel a pull, a call, an invitation to go deeper. This is your guidance system; it leads you toward what you need to find. The challenge: the pull can become addictive. You may follow every resonance without discrimination, chasing mystery for its own sake rather than for what it reveals. Learn to evaluate: is this pull toward depth or just toward novelty? Is this mystery worth entering, or just attractive? Not every call needs answering.',
    gid_out: 'Questioning',
    gid_out_d: 'You communicate through questions—opening inquiry, inviting exploration, challenging assumptions. Your questions are not requests for information but invitations to seek together. This makes you a natural teacher and guide; you do not give answers but provoke people to find their own. Your questions can unlock doors others did not know existed. The challenge: sometimes people need answers, not more questions. Learn when to ask and when to tell, when to open inquiry and when to offer conclusion. Let your questions be genuinely curious rather than disguised answers or tests.',
    rel_align: 'You thrive in relationships that are themselves quests—partnerships where both people are seeking, where the relationship is a shared journey of discovery, where meaning-making is a collaborative project. You need partners who are themselves curious, who ask questions rather than assuming they know, who find spiritual and intellectual exploration as essential as you do. The ideal Seeker partner is a fellow traveler—not necessarily on the same path but equally committed to the journey, able to share what they find and receive what you discover.',
    rel_chal: 'Your primary relationship challenge is the "grass is greener" syndrome—always wondering if there is a better partner somewhere else, treating relationships as way-stations on your seeking journey rather than destinations in themselves, failing to commit fully because commitment feels like the end of seeking. You may be chronically dissatisfied with partners who are actually wonderful, always sensing something missing, unable to rest in what is present because you are oriented toward what might be. The work: recognize that relationships themselves are territories to explore, that depth comes from staying rather than leaving, and that the partner in front of you is as infinite as any horizon. Seek WITHIN the relationship, not outside it.',
    ritual_name: 'The Center Point',
    ritual_steps: [
      'Find a comfortable seated position and close your eyes. For this ritual, you will not be going anywhere—no journeying, no exploration, no outward seeking. You will be finding the center.',
      'Place one hand on your heart and the other on your belly. These are not arbitrary positions—they anchor your awareness in your body, the one place from which you cannot wander.',
      'Take several deep breaths, letting each exhale be longer than the inhale. With each breath, feel yourself settling, becoming heavier, more present, more HERE.',
      'Now ask yourself the ultimate Seeker question: "Who is it that seeks?" Do not try to answer with words. Let the question itself be the practice. Feel into who is asking, who is wanting to know, who is behind all your seeking.',
      'Notice: the one who seeks is already here. You do not need to go anywhere to find the seeker. The seeker is you, present, now, in this body, in this breath. What you seek is seeking you.',
      'Rest in this recognition. Not understanding it intellectually but FEELING it: the presence that does not need to go anywhere because it already IS everywhere it needs to be.',
      'When thoughts arise of other places to go, other things to find, gently return to the hand on your heart. Here. Now. This. The center point is not a destination you reach but a reality you recognize.',
      'Sit until you feel the truth of this: you have already arrived. You have always already arrived. The seeking can continue from a place of having found, rather than desperately trying to find.',
      'Use this ritual whenever your seeking becomes frantic, whenever the eternal wander threatens to exhaust you. Return to center. Remember what you have already found: yourself, here, now.'
    ],
    vocation: 'Philosopher / Guide',
    cycle: 'Quest',
    cycle_desc: 'The journey of searching and discovery—you are designed to ask the questions that lead others to truth.',
    summary_synthesis: 'You are the question that drives the universe—the relentless inquiry that refuses to accept the superficial, the eternal seeker who follows the trail of meaning through every wilderness until truth is found. This is not restlessness but function; without Seekers, humanity would accept its first answers and never discover deeper ones. You are the evolutionary edge of consciousness, always pushing toward greater understanding. But hear this truth: what you seek is not a place you find but a frequency you become. The treasure is not at the end of the journey; the treasure is the one who journeys. Every external seeking is a projected form of the ultimate seeking—the search for your own deepest nature, already present, already whole, already here. When you finally stop running toward the next horizon and turn your inquiry inward, you discover what the mystics have always known: the seeker and the sought are one. You have been what you were looking for all along. This is not the end of seeking but its completion—seeking from fullness rather than from lack, questing as celebration rather than desperation, asking questions not to find what is missing but to explore what is infinite. Rest in the center. You have already arrived. Now your seeking truly begins.'
  },
  'Healer': {
    contract: 'To restore harmonic alignment to distorted fields—to perceive what is out of tune, sense where the energy is blocked or corrupted, and facilitate the return to coherence. You are the living tuning fork whose presence alone begins to correct distortion in the systems around you. This is not about fixing what is broken (that implies judgment) but about restoring what has lost its harmony. Every living system has a frequency of health, a pattern of coherence that represents its optimal functioning. Illness, dysfunction, and suffering arise when systems deviate from their harmonic pattern. You perceive this deviation and—through your presence, your attention, your techniques, or simply your frequency—support the system in returning to its natural coherence. You do not heal anyone; you create conditions in which healing can occur.',
    glitch_name: 'Resonance Burnout',
    glitch_desc: 'Your primary dysfunction is absorbing the distortion you are meant to help clear—taking on the illness, the pain, the dysfunction of those you work with until you become sick yourself. This manifests as chronic exhaustion after healing work, mysterious symptoms that mirror your clients\' conditions, emotional overwhelm from absorbing others\' feelings, blurred boundaries between your energy and theirs, and eventual burnout as you give from an empty vessel. You may find yourself unable to stop healing even when depleted, drawn to the most damaged people like a moth to flame, or becoming progressively sicker as you help others become well. The deeper pattern: you have confused empathy with absorption, and your identity has become so merged with healing that you cannot exist without wounds to heal—even if they must be your own.',
    glitch_fix: 'Clear yourself as a primary discipline—before, during, and after any healing work. This is not optional; it is essential. Specific practices: Establish rigorous energetic hygiene: visualize clearing after every session, use salt water or smoke to cleanse, shake your body to discharge absorbed energy. Set clear boundaries about when you are "on" and "off" as a healer; do not be available to everyone all the time. Learn to perceive without absorbing—you can feel the distortion without taking it on. Work with your own healing consistently; your wounds are not meant to stay open to help others. Remember: you are most effective when clear. An overloaded tuning fork cannot produce a pure tone. Your clarity IS your healing capacity.',
    oil_name: 'Lavender',
    oil_desc: 'Lavender restores equilibrium—it is the universal balancer, calming what is agitated, lifting what is depressed, bringing the system back to center. For Healers, Lavender serves as your signature oil: it does what you do. Use it liberally in your healing work and in your personal practice. Apply it after sessions to clear and restore. Diffuse it in healing spaces to establish a coherent field. Lavender also teaches something important: balance is not static but dynamic. You are not trying to freeze systems in one state but to restore their capacity for dynamic equilibrium. Let Lavender remind you: healing is about restoring flow and flexibility, not about imposing a single "correct" state.',
    crystal_name: 'Green Aventurine',
    crystal_desc: 'Green Aventurine is the heart healer—it restores energetic flow and releases blockages, particularly those related to giving and receiving, which is precisely your territory. Its green color resonates with the heart chakra, the center of love and healing. For Healers, Green Aventurine serves as both tool and medicine. Use it in healing work by placing it on yourself or others. Keep it in your healing space. Most importantly, use it for YOUR healing—your heart needs care as much as anyone\'s. Green Aventurine teaches: the healer must be healed. The channels through which healing flows must themselves be clear. Your heart must be open and flowing for healing to move through you effectively.',
    metal_name: 'Silver',
    metal_desc: 'Silver is intuitive reflection—it mirrors, it perceives, it receives lunar energy that illuminates what is hidden. For Healers, Silver resonates with your perceptual capacity: you SENSE what is out of alignment, often before you consciously know why. Silver also has antimicrobial properties, having been used for healing across cultures. It is the metal of the Moon, governing intuition, emotion, and the subtle body where healing actually occurs. Wear Silver to enhance your healing perception. Use Silver tools (cups, bowls, jewelry) in your healing space. Let Silver teach you: healing often requires seeing in the dark, perceiving what is not obvious, trusting your intuitive sense of what is needed.',
    animal_name: 'Dolphin',
    animal_desc: 'The Dolphin is your spirit teacher because it embodies sonic intelligence and the joy of healing. Dolphins heal through sound—they use echolocation that some researchers believe has therapeutic effects on those they encounter. They also represent the integration of playfulness and power, joy and depth, lightness and significance. When Dolphin appears in your life, it asks: Are you healing with joy, or has healing become a burden? Are you using sound and vibration in your work? Are you remembering to play, to be light, to experience the pleasure of being alive? Dolphin teaches: the most powerful healing comes through joy, not through suffering. If your healing work has become heavy, you have lost something essential. Let Dolphin medicine restore your delight.',
    music_name: 'Nature Sounds / Binaural',
    music_desc: 'Nature sounds and binaural frequencies entrain the nervous system to coherence—they do what you do, which is restore harmony to distorted fields. These sounds bypass the cognitive mind and work directly on the body\'s resonance. For Healers, this music serves as a tool and an ally. Use binaural beats to help shift brainwave states in those you work with (and yourself). Use nature sounds to ground and restore after sessions. Play coherence-inducing frequencies during healing work to support the process. This music teaches: healing happens at the level of vibration. Words and intentions are important, but the deeper work is frequency matching—helping distorted systems remember their coherent pattern.',
    color_name: 'Green',
    color_desc: 'Green is the heart frequency—balance, healing, and regeneration in visible form. It is the color of growing things, of spring, of life renewing itself. Green sits at the center of the visible spectrum, perfectly balanced between warm and cool, just as the heart sits at the center of the chakra system, balancing upper and lower, spiritual and physical. For Healers, green resonates with your core function. Surround yourself with green—plants, fabrics, walls. Wear green during healing work. Visualize green light filling and emanating from your heart when you are facilitating healing. Green teaches: healing is not dramatic rescue but gentle balance. It is not forcing a state but inviting return to natural harmony.',
    freq_name: '528 Hz',
    freq_desc: 'The frequency of DNA repair—528 Hz works at the most fundamental level of the physical body, supporting cellular repair and regeneration. For Healers, this frequency represents the depth at which true healing occurs: not just symptoms, not just emotions, but the very code from which the body is built. Use 528 Hz in your healing work to support deep restoration. Play it during sessions, especially when working with chronic conditions or cellular-level issues. Use it for your own healing, regularly. 528 Hz teaches: healing goes deeper than we usually imagine. You are not just addressing this condition but supporting the body\'s entire capacity for coherence. Work at the root; the branches will follow.',
    geo_name: 'Vesica Piscis',
    geo_desc: 'The Vesica Piscis is the geometry of convergence—two circles overlapping to create an almond-shaped center where they meet. This is the space of healing: where two fields (healer and healed, old state and new state, illness and wellness) overlap and interact. The Vesica Piscis is also the shape from which many sacred proportions derive; it is generative, the geometry of birth. For Healers, this is your geometric signature: you create the space of convergence where healing can occur, the overlap where change becomes possible. Meditate on the Vesica Piscis to understand your function. You are not one circle imposing on another; you are the space where two circles meet and something new can emerge.',
    gid_in: 'Dissonance Scan',
    gid_in_d: 'You perceive the world through a healing lens—automatically scanning for distortion, blockage, disharmony, and dis-ease. When you enter a room, you sense where the energy is stuck. When you meet a person, you perceive where they are out of alignment. When you touch a body, you feel the blockages and restrictions. This dissonance scanning is the diagnostic capacity that makes your healing possible; you know what is wrong before anyone tells you. The challenge: constant dissonance scanning is exhausting, and you may have difficulty turning it off. Learn to modulate your perception—scanning deeply when you are in healing mode, dialing back when you are off duty.',
    gid_proc: 'Harmonic Restoration',
    gid_proc_d: 'Your mind naturally processes toward coherence—taking distorted input and seeking its resolution, finding the harmonic pattern beneath the dissonance, identifying the pathway from current state to healed state. This is automatic. When you encounter dysfunction, your mind immediately begins processing how to restore function. This makes you a natural problem-solver in the healing domain; you see not just what is wrong but what would be right, and how to get there. The challenge: you may try to restore harmony where it is not yours to restore, processing others\' lives without being asked. Learn to engage this function only when invited.',
    gid_dec: 'Alignment Check',
    gid_dec_d: 'Your decisions are made through alignment—choosing what moves toward health, coherence, and wholeness. When considering options, you automatically check: which one is more aligned? Which supports healing? Which moves toward harmony? This is your guidance system, and it keeps you oriented toward your function. The challenge: you may apply alignment checking to everyone else\'s decisions and become frustrated when they choose misalignment. Others have their own paths. Your alignment check is for YOUR decisions; let others have their own navigation systems.',
    gid_out: 'Soothing Wave',
    gid_out_d: 'You communicate through calm—your voice, your presence, your words carry a soothing frequency that begins to regulate the nervous systems of those who receive it. This is not something you do; it is something you are. When you speak, people relax. When you enter a room, tension decreases. This soothing wave is part of your healing capacity; you are already working before any technique begins. The challenge: soothing can become avoidance. Sometimes people need activation, not calming; sometimes the truth is disturbing and should not be smoothed over. Learn when to soothe and when to stimulate, when to calm and when to challenge.',
    rel_align: 'You thrive in relationships with good energetic hygiene—partnerships where both people maintain their own energy fields, where codependency is not enabled, and where you are not cast in the role of constant healer. You need partners who take responsibility for their own healing rather than expecting you to be their therapist, who understand the need for energetic boundaries, and who can meet you as an equal rather than as a patient. The ideal Healer partner supports your healing work without being your client, maintains their own wellbeing rather than depending on yours, and provides you with the rare experience of being cared for rather than always caring.',
    rel_chal: 'Your primary relationship challenge is trauma bonding—being drawn to the most wounded, forming relationships based on healing rather than partnership, becoming indispensable through fixing and then being unable to leave even when the relationship is harmful. You may choose partners specifically for their wounds (consciously or not), may feel threatened when they heal (because what is your role now?), and may unconsciously keep them slightly sick to maintain your position. The work: choose partners for who they ARE, not for what they need healed. Let relationships be about mutual nourishment, not about you healing them. Notice if you are attracted to wounds rather than wholeness. Healing is your work, but it should not be the basis of your love relationships.',
    ritual_name: 'The Salt Cleanse',
    ritual_steps: [
      'This ritual is for clearing accumulated distortion from your field after healing work or any situation where you may have absorbed energy that is not yours. Perform it regularly, ideally daily.',
      'Prepare warm water with dissolved sea salt in a basin, or simply run water over your hands if that is what is available. Salt is a natural energy cleanser used across cultures for purification.',
      'Place your hands in or under the water. Close your eyes and take a deep breath. Visualize the water as liquid light, bright and clean.',
      'As the water runs over your hands, visualize any gray, sticky, or dark energy that you have absorbed flowing off your hands and into the water. Watch it dissolve, neutralize, transform. This is not your energy; you are releasing it.',
      'Continue until your hands feel clear—light, tingly, clean. You will feel the difference between before and after.',
      'Shake your hands vigorously in the air, dispersing any remaining energy. This physical gesture helps discharge what the water may not have caught.',
      'Dry your hands with a clean towel. Take a moment to feel your own energy, clear and present. THIS is your baseline; anything else is absorption.',
      'For deeper cleansing, take a full salt bath, visualizing your entire field clearing as you soak. Immerse yourself completely if possible.',
      'This ritual is non-negotiable for Healers. The distortion you absorb will make you sick if you do not clear it. Energetic hygiene is as essential as physical hygiene. Do not skip it.'
    ],
    vocation: 'Therapist / Healer',
    cycle: 'Restoration',
    cycle_desc: 'The return to harmony and balance—you are designed to facilitate the healing of what has become distorted.',
    summary_synthesis: 'You are the tuning fork—when you are clear, your presence alone corrects the distortion around you. This is not arrogance but accurate description of your function. A pure tone, sustained and stable, entrains chaotic vibrations to itself. Dissonance seeks resolution; distortion wants to return to coherence. YOU are the coherent pattern that suffering systems can tune to. But here is the crucial truth: a tuning fork encrusted with distortion cannot produce a pure tone. If you absorb without clearing, take on without releasing, give without receiving, you become what you were meant to heal—distorted, blocked, dysregulated. Then your presence adds to the chaos rather than correcting it. Your first healing responsibility is to YOURSELF. Your clarity is your capacity. Your coherence is your gift. Do not try to fix the world through effort and sacrifice; simply hold your own note—clear, pure, stable—and the world will tune itself to you. Those who are ready for healing will feel your frequency and entrain. Those who are not ready will move away. This is as it should be. Your work is to hold the note. The healing belongs to those who receive it.'
  },
  'Mystic': {
    contract: 'To unify dualities and dissolve the illusion of separation—to perceive and transmit the fundamental truth that all apparent distinctions are temporary expressions of an underlying unity. You are not here to play within the game of form but to remember (and help others remember) that the game IS a game, that the forms ARE forms, that beneath all the drama of polarities and differences lies an undivided wholeness that has never been fragmented. The Mystic function is the ultimate human capacity: to perceive through the veil of maya, to see the One expressing itself as many, to rest in the space between thoughts where the infinite resides. Without Mystics, humanity forgets its source and becomes lost in the play, mistaking the costumes for the actors, the drama for reality. You are the reminder that we are not separate, have never been separate, and that all journeys home are actually discoveries that we never left.',
    glitch_name: 'Grounding Failure',
    glitch_desc: 'Your primary dysfunction is disassociation from physical reality—floating so far into transcendence that you lose your body, your relationships, your practical function, and your capacity to serve as a bridge between dimensions. This manifests as chronic spaciness and inability to focus on mundane tasks, physical health problems from neglecting the body, relationship failures from being unable to "be here" with others, impracticality that makes daily life nearly impossible, and using spiritual states to escape rather than transform material reality. You may find yourself with profound cosmic insights but unable to pay your bills, understanding the nature of ultimate reality while your immediate reality crumbles, dismissing physical suffering (yours or others\') as "mere illusion" while actually being in pain. The deeper pattern: transcendence has become escape, and unity consciousness has become a way to avoid the challenging work of being an embodied, incarnate presence.',
    glitch_fix: 'Engage the physical deliberately and rigorously—ground your transcendent perception into embodied presence. Specific practices: Do physical exercise DAILY, preferably something that requires body awareness like yoga, martial arts, or dance. Touch the earth; walk barefoot, garden, work with physical materials. Eat real food mindfully, attending to the experience of taste and nourishment. When you notice yourself floating away, stomp your feet, clap your hands, do something that demands bodily presence. Practice bringing your consciousness INTO your body rather than hovering above it. Remember: you took a body for a reason. Transcendence that rejects incarnation is not completion but avoidance. The goal is to be BOTH infinite AND finite, transcendent AND embodied, unified AND particular. Ground the infinite; embody the transcendent. THAT is the full Mystic function.',
    oil_name: 'Jasmine',
    oil_desc: 'Jasmine unifies spirit and body—its intoxicating scent is itself a portal between dimensions, earthy and heavenly simultaneously. Jasmine has been used in sacred ceremonies across cultures to invite divine presence into human reality, to make the transcendent imminent. For Mystics, Jasmine serves as a bridging agent: it helps you bring your cosmic perception down into your body, and helps your body rise up to meet your spiritual awareness. Use Jasmine when you feel too far out, too disconnected from physical reality. Apply it and breathe deeply, letting its fragrance call you back into incarnate presence. Jasmine teaches: the body is not an obstacle to the sacred but its temple. Spirit wants to be embodied; that is why you are here.',
    crystal_name: 'Labradorite',
    crystal_desc: 'Labradorite is the stone of magic—it bridges multiple realities and dimensional awareness, shimmering with colors that only appear when viewed from certain angles (just as transcendent truth only appears from certain perspectives). Labradorite holds the paradox of the visible and invisible, the manifest and unmanifest, the formed and formless. For Mystics, Labradorite is an essential ally: it supports your capacity to perceive across dimensions while maintaining grounded presence. Keep Labradorite with you to stabilize your interdimensional perception. Use it in meditation to open to other realms safely. When you feel ungrounded from excessive transcendence, hold Labradorite and let it help you find the balance point between worlds.',
    metal_name: 'Quicksilver',
    metal_desc: 'Quicksilver (Mercury) represents the merging of dualities—it is liquid yet metal, solid yet fluid, stable yet ever-changing. It has no fixed shape, taking the form of whatever contains it while maintaining its essential nature. This is Mystic consciousness: formless yet taking form, undefined yet specific, everywhere yet here. Quicksilver cannot be grasped, and this is its teaching: what you perceive in your mystical states cannot be held, only experienced. The moment you try to capture it, it slips away. Work with Quicksilver symbolically (it is toxic in physical form): appreciate its paradoxical nature, let it teach you how to be both fixed and fluid, both present and transcendent. You are Quicksilver: apparently changing form constantly while being, in essence, always the same.',
    animal_name: 'Butterfly',
    animal_desc: 'The Butterfly is your spirit teacher because it embodies total metamorphosis—complete dissolution of one form and reformation as another, death and rebirth within a single lifetime. The caterpillar literally liquefies inside the chrysalis before becoming butterfly; its old form entirely dissolves. This is Mystic medicine: the willingness to die completely to the old to become the new, to dissolve the structures of the self to reform as something radically different. When Butterfly appears in your life, it asks: What old form are you being asked to dissolve? Are you willing to go through the liquid phase, the not-knowing, the complete surrender of previous identity? Butterfly teaches: transformation is not modification but metamorphosis. You are not becoming a better caterpillar; you are becoming a butterfly.',
    music_name: 'Sacred / Mantric',
    music_desc: 'Sacred and mantric music carries vibrational codes that dissolve the illusion of separation—sounds designed not for entertainment but for consciousness shifting. These are the sounds of temples, of ancient ceremonies, of practices refined over millennia to induce transcendent states. For Mystics, this music serves as a tool and a reminder. Use mantric sounds to support your practice: let the repetition of sacred syllables quiet the mind and open the space between thoughts where the infinite resides. Let sacred music be the soundtrack of your internal temple. But also let it teach you: these sounds work because sound itself is not separate from its source. The vibration that dissolves duality is not fundamentally different from any other vibration—it is just self-aware. All sound is sacred; these particular sounds help you remember.',
    color_name: 'White',
    color_desc: 'White is all frequencies unified—pure light containing all colors, all possibilities, all expressions within its apparently empty simplicity. It is not a single color but the integration of all color, just as unity is not the destruction of diversity but its integration. For Mystics, white resonates with your perception: you see through the apparent differences to the underlying unity that contains them all. Use white in your practice spaces. Wear white when you need to remember the unity beneath diversity. Visualize white light when you seek to dissolve the perception of separation. White teaches: what appears empty is actually full. What appears simple is actually complete. The pure, undifferentiated light contains everything.',
    freq_name: '963 Hz',
    freq_desc: 'The frequency of Oneness—963 Hz is sometimes called the frequency of the Divine, of pure unity, of connection to source consciousness. It dissolves the perception of separation at the deepest level, supporting the experience of unity that is the Mystic\'s native state. Use 963 Hz in meditation, in practice, in any moment when you need to remember what is ultimately true beneath the apparent fragmentation. This frequency does not create unity—unity is already true—it helps you perceive what has always been the case. 963 Hz teaches: oneness is not an achievement but a recognition. You are already one with everything; you always have been. The frequency simply helps you remember what you have never actually forgotten.',
    geo_name: 'Metatron Cube',
    geo_desc: 'Metatron\'s Cube is the map of creation itself—it contains all five Platonic solids and represents the geometric pattern from which all form emerges. It is the blueprint of manifestation, the code underlying reality. For Mystics, Metatron\'s Cube represents the perception you have access to: the ability to see the pattern behind the pattern, the form behind the forms, the organizing principle that generates all apparent diversity from unified source. Meditate on Metatron\'s Cube to strengthen your perception of the underlying order. Visualize it when you feel overwhelmed by apparent chaos; let it remind you that all diversity emerges from a single pattern, and that pattern is knowable. You are designed to see the Cube; it is the map of the territory you navigate.',
    gid_in: 'Unity Perception',
    gid_in_d: 'You perceive the world through unity—automatically seeing the connections that bind apparently separate phenomena, perceiving the one expressing itself as many, sensing the fundamental non-separation beneath all apparent boundaries. Where others see objects, you see relationships. Where others see separates, you see wholes. Where others see individuals, you see expressions of the same source. This unity perception is your gift and your challenge: it allows you to perceive what is ultimately true, but it can also make the world of form seem unreal, irrelevant, or even illusory in a dismissive way. Learn to honor both levels: unity IS true, AND form is meaningful. They are not in conflict; they are two ways of seeing the same truth.',
    gid_proc: 'Quantum Synthesis',
    gid_proc_d: 'Your mind holds paradox—it can contain apparent contradictions without needing to resolve them into false simplicities. This is quantum cognition: the capacity to hold "both/and" rather than needing "either/or." In your mind, a thing can be both wave and particle, both here and there, both self and other, both formed and formless. This processing style allows you to perceive truths that transcend ordinary logic, to hold the complexity of reality without breaking it into manageable (but inaccurate) fragments. The challenge: people around you may find your thinking confusing, and you may struggle to communicate insights that cannot be reduced to ordinary logic. Learn to translate, to offer simplified versions while knowing they are not complete.',
    gid_dec: 'Divine Allow',
    gid_dec_d: 'Your decisions are made through surrender—allowing rather than forcing, receiving rather than grasping, trusting that what needs to happen will happen. This is not passivity but deep alignment: you have learned that the universe knows what it is doing, and that your job is often to get out of the way rather than to impose your will. When you let go, the right action reveals itself; when you surrender, the path becomes clear. The challenge: surrender can become excuse, and "allowing" can become avoidance of necessary action. Learn to discern when genuine allowing is appropriate and when action is required. Sometimes the divine allows you to choose; choose.',
    gid_out: 'Vibrational Omen',
    gid_out_d: 'You communicate from the void—your words carry frequencies that sometimes surprise even you, transmissions that seem to come from beyond your personal knowing. When you speak from your deepest place, you become a channel for something larger, and what emerges may be oracular, prophetic, or mysteriously precisely relevant to what the listener needs. This vibrational communication operates beyond ordinary language; people receive something from your presence that exceeds your words. The challenge: this capacity can become inflated ("I am a channel for the Divine") or frightening (when you do not recognize what comes through you). Let it be what it is: a gift, a function, not an identity. You are the channel, not the source.',
    rel_align: 'You thrive in relationships that are themselves experiences of union—partnerships where the boundary between self and other becomes permeable, where the relationship is a portal to transcendence, where intimacy opens into the infinite. You need partners who are themselves spiritually oriented (they do not have to be Mystics, but they must have a relationship with the transcendent), who can meet you in the depths rather than only on the surface, and who are willing to let the relationship be sacred, not just functional. The ideal Mystic partner joins you in perceiving through the veil while also helping you stay grounded in embodied reality.',
    rel_chal: 'Your primary relationship challenge is spiritual bypassing—using transcendence to avoid the difficult, messy, embodied work that real intimacy requires. You may dismiss relational problems as "illusion," avoid conflict by retreating into "everything is one," or neglect your partner\'s actual human needs because you are focused on their cosmic nature. You may choose relationships that are "spiritual" but not actually intimate, using shared practice as a substitute for genuine vulnerability. The work: learn that transcendence does not excuse you from showing up. Learn that "we are one" does not mean you can skip the difficult conversations. Let your mystical perception inform your relationships but not replace the human work of being present, accountable, and genuinely connected to the actual person in front of you.',
    ritual_name: 'The Void Sit',
    ritual_steps: [
      'Create complete darkness—a room with no light, all sources blocked. This is not meditation in dim light; it is immersion in darkness so complete that the eyes cannot find form to rest on.',
      'Sit comfortably, in a position you can maintain for an extended period. This practice may go deep; you need to be able to stay.',
      'Keep your eyes open. This is important: you are not trying to see inner visions but to merge with the formless. With eyes open in complete darkness, there is no difference between open and closed, between outside and inside. This is the lesson.',
      'Breathe normally. Do not try to achieve anything. Simply sit, with open eyes, in complete darkness, and let the darkness receive you.',
      'As you sit, notice the dissolution of boundaries. Where is the edge of your body? Where is the edge of the darkness? Where is the difference between you and the void? Let these distinctions soften and blur.',
      'Do not resist if thoughts, images, or sensations arise. Let them float through the void like clouds in empty sky. You are not trying to eliminate content but to recognize the emptiness in which content appears.',
      'Stay as long as you can—twenty minutes minimum, but hours if possible. The depths open slowly. The void reveals itself to those who wait.',
      'When you complete the practice, do not immediately turn on lights. Transition slowly. Let your eyes adjust. Notice how form re-emerges from formlessness. This is creation itself: forms arising from the void, distinctions appearing in what was previously undifferentiated.',
      'Carry the void with you. You have touched the source. Let it inform your formed life without replacing it. Be both—infinite and finite, formless and formed, unified and particular. This is the Mystic path.'
    ],
    vocation: 'Mediator / Mystic',
    cycle: 'Union',
    cycle_desc: 'The dissolution of boundaries and perception of underlying unity—you are designed to see through the veil and help others remember what they truly are.',
    summary_synthesis: 'You are the space between the atoms—the emptiness in which all forms appear, the silence in which all sounds arise, the unity in which all diversity plays. While others engage with the game of form, you hold the frequency of the formless, perceiving through the costumes to the single actor wearing them all. This is your gift, your perception, your function. But hear this crucial truth: you took a body for a reason. You incarnated into form, into particularity, into apparent separation not to escape back into unity at the first opportunity but to bring the infinite down into the finite, to ground the transcendent in the imminent, to be BOTH heaven AND earth. The Mystic who floats above embodiment, using unity as an excuse to avoid the challenges of incarnation, has missed the point. You are not here to transcend and leave; you are here to transcend and STAY, to perceive unity while honoring form, to know that we are one while fully showing up as the particular expression you are. This is the Mystic\'s true work: not to escape the world but to transform it by holding the frequency of what it truly is. Not to reject the game but to play it consciously, knowing it is a game while playing it with full commitment. Be the space between the atoms AND the atoms themselves. Be the formless AND the form. That is why you came.'
  }
};

const NUMEROLOGY = {
  1: { title: 'The Pioneer', desc: 'Driven by individualization and will. You are the initiating force that blazes trails where none existed, the spark of self that declares "I AM" and begins the journey of manifestation. Your soul learns through leadership, independence, and the courage to stand alone when necessary. The challenge of 1 is ego inflation; the gift is authentic self-expression that inspires others to find their own.' },
  2: { title: 'The Diplomat', desc: 'Intuitive and receptive. You master the art of cooperation, partnership, and the perception of detail that others miss. Where 1 declares, 2 listens; where 1 leads, 2 supports. Your soul learns through relationship, sensitivity, and the patience that allows others to unfold in their own time. The challenge of 2 is dependency and loss of self; the gift is the capacity to create harmony and hold space for others to become themselves.' },
  3: { title: 'The Creator', desc: 'Expressive and joyful. You communicate truth through creativity, turning the raw material of experience into art, story, and expressed beauty. Your soul learns through creation, communication, and the joy of bringing the internal into external form. The challenge of 3 is scattered energy and superficiality; the gift is the capacity to uplift others through your creative expression and infectious optimism.' },
  4: { title: 'The Builder', desc: 'Grounded and disciplined. You build systems that endure, structures that support, foundations that last. Your soul learns through patience, hard work, and the dedication required to make lasting form. Where others dream, you construct. The challenge of 4 is rigidity and limitation; the gift is the capacity to create structures that serve life for generations.' },
  5: { title: 'The Catalyst', desc: 'Volatile and adventurous. You disrupt stagnation and teach adaptability through your own constant movement and change. Your soul learns through variety, freedom, and the courage to try everything life offers. The challenge of 5 is excess and instability; the gift is the capacity to help others embrace change and find freedom within form.' },
  6: { title: 'The Nurturer', desc: 'Responsible and harmonious. You master the balance of service and self-care, learning to give from fullness rather than depletion. Your soul learns through family, community, and the art of creating beauty and harmony in environments. The challenge of 6 is martyrdom and over-giving; the gift is the capacity to create homes—physical and emotional—where others can flourish.' },
  7: { title: 'The Seeker', desc: 'Introspective and analytical. You uncover hidden truths through solitary investigation, inner inquiry, and the refusal to accept surface answers. Your soul learns through study, contemplation, and the courage to question everything. The challenge of 7 is isolation and over-thinking; the gift is the capacity to find truth that serves the collective through your private seeking.' },
  8: { title: 'The Executive', desc: 'Authoritative and ambitious. You master the flow of material resources, understanding power, money, and manifestation. Your soul learns through achievement, leadership, and the responsible use of influence. The challenge of 8 is materialism and domination; the gift is the capacity to create abundance that serves many.' },
  9: { title: 'The Humanitarian', desc: 'Compassionate completion. You serve the collective, understanding that your individual story is part of a larger tapestry. Your soul learns through service, release, and the wisdom that comes from completing cycles. The challenge of 9 is martyrdom and inability to receive; the gift is the capacity for universal love that embraces all.' },
  11: { title: 'The Illuminator', desc: 'A Master Number of spiritual insight and intuitive power. You function as a lightning rod for higher consciousness, receiving and transmitting information from beyond ordinary awareness. Your soul has chosen an accelerated path of spiritual awakening, and you are here to illuminate the way for others. The challenge of 11 is nervous tension and impracticality; the gift is the capacity to channel divine light into human understanding.' },
  22: { title: 'The Master Builder', desc: 'A Master Number of material manifestation on a grand scale. You turn spiritual ideals into concrete reality, building structures (organizations, systems, actual buildings) that serve humanity for generations. Your soul has chosen the demanding path of making heaven visible on earth. The challenge of 22 is overwhelm and inability to live up to your vision; the gift is the capacity to create lasting form from transcendent vision.' },
  33: { title: 'The Master Teacher', desc: 'The highest Master Number, representing pure devotion to the upliftment of humanity. You teach through being—your very presence is instructive. Your soul has taken on the rare burden of offering yourself as a living teaching for others. The challenge of 33 is the weight of others\' expectations and the temptation to martyrdom; the gift is the capacity to raise the consciousness of all who encounter you through your love and example.' }
};

/***************************************************************
   HOUR QUADRANTS - Birth Time Coherence Modulation
   Maps the 24-hour cycle to four quadrants that modulate
   how your archetype expresses and processes
****************************************************************/
const HOUR_QUADRANTS = {
  'Q-III': {
    name: 'Night Gate (Stillness)',
    hours: '00:00 - 05:59',
    hourRange: [0, 5],
    quadrantFeel: 'Gentle, patient, non-demanding presence',
    voiceTexture: 'Low, soft, steady; no pressure to perform or produce',
    coreModulation: 'Your archetype expresses through depth, patience, and introspective processing. You work from the inside out, allowing things to gestate before they emerge.',
    cognitiveShift: 'Your intake is receptive rather than seeking; your processing is contemplative rather than analytical; your decisions emerge from stillness rather than momentum; your output is understated but profound.',
    glitchManifestation: 'Your dysfunction tends to manifest as withdrawal, depression-adjacent patterns, or passive resistance. When stressed, you go quiet rather than reactive.',
    vocationalApproach: 'You excel in roles that allow deep work without constant external pressure. Night shifts, solitary creative work, behind-the-scenes positions, dream work, and holding space for others in crisis.',
    relationshipStyle: 'You need partners who do not demand constant engagement. You offer steady, patient presence but may struggle with partners who need high-energy interaction. Your repair style is slow and gentle.',
    ritualTiming: 'Your practices are most potent in the pre-dawn hours. Stillness practices, dream work, and deep meditation align with your birth frequency.',
    integration: 'Learn to emerge from stillness into action without losing your depth. Your gift is the ability to hold space; your growth edge is learning to also fill it.'
  },
  'Q-I': {
    name: 'Dawn Gate (Flow)',
    hours: '06:00 - 11:59',
    hourRange: [6, 11],
    quadrantFeel: 'Warm clarity, emotional momentum, engaged presence',
    voiceTexture: 'Bright, engaged, energetic; forward-moving without pressure',
    coreModulation: 'Your archetype expresses through initiation, momentum, and active engagement. You work from clarity into action, starting things and building energy.',
    cognitiveShift: 'Your intake is active and seeking; your processing builds momentum; your decisions come quickly from clear perception; your output is generative and inspiring.',
    glitchManifestation: 'Your dysfunction tends to manifest as anxiety, over-activity, or scattered energy. When stressed, you speed up rather than slow down, potentially burning out.',
    vocationalApproach: 'You excel in roles that involve starting projects, inspiring teams, morning leadership, and pioneering new territory. Entrepreneurship, teaching, coaching, and any role requiring initiative.',
    relationshipStyle: 'You bring energy and momentum to partnerships. You may struggle with partners who are slow to engage or who dampen your enthusiasm. Your repair style is active and solution-oriented.',
    ritualTiming: 'Your practices are most potent in the morning hours. Movement practices, intention-setting, and active meditation align with your birth frequency.',
    integration: 'Learn to sustain what you start without requiring constant momentum. Your gift is initiation; your growth edge is learning to also complete and rest.'
  },
  'Q-II': {
    name: 'Day Gate (Tension)',
    hours: '12:00 - 17:59',
    hourRange: [12, 17],
    quadrantFeel: 'Grounded containment, productive pressure, focused engagement',
    voiceTexture: 'Shorter lines, calmer rhythm, task-oriented but warm',
    coreModulation: 'Your archetype expresses through pressure-response, containment, and productive tension. You work well under deadlines and external structure, converting stress into output.',
    cognitiveShift: 'Your intake filters for relevance under pressure; your processing is efficient and prioritized; your decisions are pragmatic and timely; your output is reliable and structured.',
    glitchManifestation: 'Your dysfunction tends to manifest as anxiety, overwhelm, or rigidity under pressure. When stressed, you may either over-control or collapse into paralysis.',
    vocationalApproach: 'You excel in roles with clear deliverables, deadlines, and external accountability. Management, project coordination, healthcare, emergency response, and any role requiring calm under pressure.',
    relationshipStyle: 'You are reliable and task-oriented in partnerships. You may struggle with ambiguity or partners who cannot handle productive tension. Your repair style is practical and direct.',
    ritualTiming: 'Your practices are most potent in the afternoon hours. Grounding practices, task-focused meditation, and containment exercises align with your birth frequency.',
    integration: 'Learn to find ease without requiring pressure to function. Your gift is productive containment; your growth edge is learning to relax without external structure.'
  },
  'Q-IV': {
    name: 'Dusk Gate (Peace)',
    hours: '18:00 - 23:59',
    hourRange: [18, 23],
    quadrantFeel: 'Stillness and reflective clarity, meaning-making presence',
    voiceTexture: 'Slow, spacious, quiet; oriented toward integration and completion',
    coreModulation: 'Your archetype expresses through reflection, synthesis, and meaning-making. You work by gathering experience and distilling it into wisdom, completing cycles.',
    cognitiveShift: 'Your intake seeks patterns and meaning; your processing synthesizes and integrates; your decisions emerge from reflection; your output carries wisdom and closure.',
    glitchManifestation: 'Your dysfunction tends to manifest as melancholy, over-reflection, or difficulty initiating. When stressed, you may ruminate or retreat into meaning-making as avoidance.',
    vocationalApproach: 'You excel in roles that involve synthesis, completion, counseling, and wisdom transmission. Therapy, editing, strategic review, elder care, and any role requiring reflective depth.',
    relationshipStyle: 'You bring depth and meaning to partnerships. You may struggle with partners who are purely action-oriented without reflection. Your repair style is thoughtful and seeks understanding.',
    ritualTiming: 'Your practices are most potent in the evening hours. Review practices, gratitude, completion rituals, and reflective meditation align with your birth frequency.',
    integration: 'Learn to act without requiring complete understanding first. Your gift is meaning-making; your growth edge is learning to begin before you have synthesized everything.'
  }
};

// Function to determine hour quadrant from time string
function getHourQuadrant(timeStr) {
  if (!timeStr) return null;
  
  // Parse time string (expecting HH:MM or HH:MM:SS format)
  const cleanTime = timeStr.trim();
  const parts = cleanTime.split(':');
  if (parts.length < 2) return null;
  
  const hour = parseInt(parts[0], 10);
  if (isNaN(hour) || hour < 0 || hour > 23) return null;
  
  // Determine quadrant based on hour
  if (hour >= 0 && hour <= 5) return 'Q-III';
  if (hour >= 6 && hour <= 11) return 'Q-I';
  if (hour >= 12 && hour <= 17) return 'Q-II';
  if (hour >= 18 && hour <= 23) return 'Q-IV';
  
  return null;
}

// Export for use in other modules
window.HOUR_QUADRANTS = HOUR_QUADRANTS;
window.getHourQuadrant = getHourQuadrant;

console.log('PEP Engine Data Loaded - 13 Archetypes, THD Phases, Scalar Modulators, Numerology, Hour Quadrants');
